import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';

class ActiveIcon extends StatelessWidget {
  final bool isActive;

  const ActiveIcon({super.key, required this.isActive});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: _allPadding,
      child: Icon(
        Icons.circle,
        color: isActive
            ? ColorsConstants.instance.appGreen
            : ColorsConstants.instance.appBlue,
      ),
    );
  }

  EdgeInsets get _allPadding => const EdgeInsets.all(kRadialReactionRadius);
}
