import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/features/message/view/message_view.dart';

import '../../../../data/repo/message_repository.dart';
import '../../../auth/login/cubit/login_cubit.dart';
import '../../cubit/message_cubit.dart';
import '../../model/query/req_fetch_group.dart';

mixin MessageViewMixin on State<MessageView> {
  late final MessageCubit _messageCubit;
  MessageCubit get messageCubitInstance => _messageCubit;

  @override
  void initState() {
    _messageCubit = MessageCubit(MessageRepository());
    _messageCubit.fetchGroupList(ReqFetchGroup(
        loginuserid: context.read<LoginCubit>().id,
        token: context.read<LoginCubit>().token,
        userfirmid: context.read<LoginCubit>().userfirmId));
    super.initState();
  }

  @override
  void dispose() {
    super.dispose();
  }

  void fetchGroup() {
    _messageCubit.fetchGroupList(ReqFetchGroup(
        loginuserid: context.read<LoginCubit>().id,
        token: context.read<LoginCubit>().token,
        userfirmid: context.read<LoginCubit>().userfirmId));
  }
}
