import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../../core/extensions/responsive_extension.dart';
import '../cubit/message_cubit.dart';
import 'mixin/group_create_view_mixin.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/constants/font_styles.dart';
import '../../../core/extensions/image_enum_extension.dart';
import '../../projects/widgets/employee_type_headline.dart';
import '../../projects/widgets/multiselect_widgets/selected_employee_chip.dart';
import '../constant/message_constant.dart';

class GroupCreateView extends StatefulWidget {
  final MessageCubit cubit;

  const GroupCreateView({super.key, required this.cubit});
  @override
  State<GroupCreateView> createState() => _GroupCreateViewState();
}

class _GroupCreateViewState extends State<GroupCreateView>
    with GroupCreateViewMixin {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: buildAppBar(
          context, MessageConstant.instance.pageTitleGroupCreateTxt),
      body: _pageColumn(
        context,
        [
          _emptyHeightSpace(context),
          _pageImage(context),
          _emptyHeightSpace(context),
          _groupNameArea(context, groupNameController,
              MessageConstant.instance.textfieldgroupNameHintTxt),
          _emptyHeightSpace(context),
          _groupLeaderEmployeeArea(
              context, secilenGrupYoneticiList, showMultiSelectLeaderEmployee),
          _showSelectedLeader(context),
          _emptyHeightSpace(context),
          _groupUserEmployeeArea(
              context, secilenGrupKullaniciList, showMultiSelectUserEmployee),
          _showSelectedUser(context),
          _emptyHeightSpace(context),
          _groupSaveButton(context, gonderilecekGrupYoneticiIdler,
              gonderilecekGrupKullaniciIdler)
        ],
      ),
    );
  }

  Widget _pageColumn(BuildContext context, List<Widget> widgetList) =>
      SingleChildScrollView(
        child: Padding(
          padding: EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.05)),
          child: Column(
            children: widgetList,
          ),
        ),
      );

  Widget _emptyHeightSpace(BuildContext context) => SizedBox(
        height: context.dynamicHeight(0.03),
      );

  Widget _emptyLowHeightSpace(BuildContext context) {
    return SizedBox(height: context.dynamicHeight(0.012));
  }

  AppBar buildAppBar(BuildContext appBarContext, String pageTitle) {
    return AppBar(
      iconTheme: const IconThemeData(color: Colors.white),
      backgroundColor: ColorsConstants.instance.baseTheme,
      title: Text(
        pageTitle,
        style: Theme.of(appBarContext)
            .textTheme
            .labelLarge
            ?.copyWith(color: Colors.white),
      ),
      centerTitle: true,
    );
  }

  Widget _pageImage(BuildContext context) => SizedBox(
      height: context.dynamicHeight(0.2), child: ImageEnums.group.toPageImage);

  Widget _headLine(BuildContext context, String title,
      {bool isRequired = true}) {
    return Row(
      children: [
        Text(
          title,
          style: FontStyles.instance.projectbxBaslik,
        ),
        isRequired
            ? Row(
                children: [
                  SizedBox(
                    width: context.dynamicWidth(0.01),
                  ),
                  Text(
                    '(zorunlu)',
                    style: FontStyles.instance.employeetbxRequired,
                  ),
                ],
              )
            : const SizedBox()
      ],
    );
  }

  Widget _groupNameArea(BuildContext context, TextEditingController controller,
          String groupNameHintTxt) =>
      Column(
        children: [
          _headLine(context, MessageConstant.instance.headlineGroupNameTxt,
              isRequired: true),
          _emptyLowHeightSpace(context),
          _groupNameTf(context, controller, groupNameHintTxt)
        ],
      );

  Widget _groupNameTf(BuildContext context, TextEditingController groupName,
          String groupNameHintTxt) =>
      Container(
        height: context.dynamicHeight(0.052),
        decoration: BoxDecoration(
            color: Colors.white,
            border: Border.all(color: Colors.grey.shade200),
            borderRadius: BorderRadius.circular(10)),
        alignment: Alignment.center,
        child: TextField(
          controller: groupName,
          decoration: InputDecoration(
            hintText: groupNameHintTxt,
            hintStyle: Theme.of(context)
                .textTheme
                .labelMedium
                ?.copyWith(color: Colors.grey.shade500),
            contentPadding:
                EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.02)),
            border: const OutlineInputBorder(borderSide: BorderSide.none),
            focusedBorder:
                const OutlineInputBorder(borderSide: BorderSide.none),
          ),
        ),
      );

  Widget _groupLeaderEmployeeArea(
          BuildContext context,
          List<String> secilenYoneticiIdler,
          void Function()? showMultiSelectLeaderEmployee) =>
      Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          _headLine(context, MessageConstant.instance.headlineGroupLeaderTxt),
          _emptyLowHeightSpace(context),
          Container(
            height: context.dynamicHeight(0.055),
            width: context.dynamicWidth(0.9),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10),
              color: context
                      .watch<MessageCubit>()
                      .secilenGrupYoneticileriIdler
                      .isNotEmpty
                  ? Colors.grey.shade200
                  : Colors.white,
              border: Border.all(
                  color: context
                          .watch<MessageCubit>()
                          .secilenGrupYoneticileriIdler
                          .isNotEmpty
                      ? Colors.grey.shade300
                      : Colors.grey.shade200),
            ),
            child: Row(
              children: [
                SizedBox(width: context.dynamicWidth(0.04)),
                Text(
                  context
                          .watch<MessageCubit>()
                          .secilenGrupYoneticileriIdler
                          .isNotEmpty
                      ? 'Seçildi'
                      : '',
                  style: const TextStyle(fontSize: 13.5),
                ),
                const Spacer(),
                IconButton(
                    padding: EdgeInsets.zero,
                    onPressed: showMultiSelectLeaderEmployee,
                    tooltip: 'Grup Yöneticilerini Seç',
                    icon: Icon(
                      Icons.arrow_drop_down_sharp,
                      size: 23,
                      color: ColorsConstants.instance.baseTheme,
                    ))
              ],
            ),
          ),
        ],
      );

// TODO: Yanlış seçilmiş değerleri gösteriyor bu kısım düzeltilecek doğru değişken isimleri seçilerek... Ardından seçili değerleri alındığına dair test yapılacak.

  Widget _showSelectedLeader(BuildContext context) => context
          .read<MessageCubit>()
          .secilenGrupYoneticileriIdler
          .isNotEmpty
      ? Column(children: [
          EmployeeTypeHeadline(
              employeeType: MessageConstant.instance.headlineGroupLeaderTxt),
          SelectedEmployeeWidget(
              selectedLeaders:
                  context.read<MessageCubit>().secilenGrupYoneticileriAdlar),
        ])
      : _emptyLowHeightSpace(context);

  Widget _groupUserEmployeeArea(
          BuildContext context,
          List<String> secilenKullaniciIdler,
          void Function()? showMultiSelectUserEmployee) =>
      Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          _headLine(context, MessageConstant.instance.headlineGroupUserTxt),
          _emptyLowHeightSpace(context),
          Container(
            height: context.dynamicHeight(0.055),
            width: context.dynamicWidth(0.9),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10),
              color: context
                      .watch<MessageCubit>()
                      .secilenGrupKullanicilariIdler
                      .isNotEmpty
                  ? Colors.grey.shade200
                  : Colors.white,
              border: Border.all(
                  color: context
                          .watch<MessageCubit>()
                          .secilenGrupKullanicilariIdler
                          .isNotEmpty
                      ? Colors.grey.shade300
                      : Colors.grey.shade200),
            ),
            child: Row(
              children: [
                SizedBox(width: context.dynamicWidth(0.04)),
                Text(
                  context
                          .watch<MessageCubit>()
                          .secilenGrupKullanicilariIdler
                          .isNotEmpty
                      ? 'Seçildi'
                      : '',
                  style: const TextStyle(fontSize: 13.5),
                ),
                const Spacer(),
                IconButton(
                    padding: EdgeInsets.zero,
                    onPressed: showMultiSelectUserEmployee,
                    tooltip: 'Grup Kullanıcılarını Seç',
                    icon: Icon(
                      Icons.arrow_drop_down_sharp,
                      size: 23,
                      color: ColorsConstants.instance.baseTheme,
                    ))
              ],
            ),
          ),
        ],
      );

  Widget _showSelectedUser(BuildContext context) =>
      context.read<MessageCubit>().secilenGrupKullanicilariIdler.isNotEmpty
          ? Column(children: [
              EmployeeTypeHeadline(
                  employeeType: MessageConstant.instance.headlineGroupUserTxt),
              SelectedEmployeeWidget(
                  selectedLeaders: context
                      .read<MessageCubit>()
                      .secilenGrupKullanicilariAdlar),
            ])
          : _emptyLowHeightSpace(context);

  Widget _groupSaveButton(BuildContext context, String gonderilenYoneticiIdler,
          String gonderilenKullaniciIdler) =>
      ElevatedButton(
        onPressed: createNewGroup,
        style: ElevatedButton.styleFrom(
            backgroundColor: ColorsConstants.instance.baseTheme),
        child: Center(
          child: Text(
            MessageConstant.instance.buttonCreateGroupTxt,
            style: Theme.of(context)
                .textTheme
                .bodyMedium
                ?.copyWith(color: Colors.white),
          ),
        ),
      );
}
