import 'dart:async';

import 'package:flutter/material.dart';

/// - Debouncer sürekli sunucuya istek atmamak için oluşturuldu

class Debouncer {
  final int milliseconds;
  VoidCallback? action;
  Timer? _timer;

  Debouncer({required this.milliseconds});

  void run(VoidCallback action) {
    if (_timer != null) {
      _timer!.cancel();
    }
    _timer = Timer(Duration(milliseconds: milliseconds), action);
  }
}
