import 'group_latest_message.dart';

import 'group_not_message.dart';

class GroupResponse {
  int? success;
  List<GroupLatestMessage>? gorusulenler;
  List<GroupNotMessage>? firmaGorusulmeyenler;
  List<GroupNotMessage>? digerGorusulmeyenler;
  String? message;

  GroupResponse(
      {this.success,
      this.gorusulenler,
      this.firmaGorusulmeyenler,
      this.digerGorusulmeyenler,
      this.message});

  GroupResponse.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    if (json['gorusulenler'] != null) {
      gorusulenler = <GroupLatestMessage>[];
      json['gorusulenler'].forEach((v) {
        gorusulenler!.add(GroupLatestMessage.fromJson(v));
      });
    }
    if (json['firma_gorusulmeyenler'] != null) {
      firmaGorusulmeyenler = <GroupNotMessage>[];
      json['firma_gorusulmeyenler'].forEach((v) {
        firmaGorusulmeyenler!.add(GroupNotMessage.fromJson(v));
      });
    }
    if (json['diger_gorusulmeyenler'] != null) {
      digerGorusulmeyenler = <GroupNotMessage>[];
      json['diger_gorusulmeyenler'].forEach((v) {
        digerGorusulmeyenler!.add(GroupNotMessage.fromJson(v));
      });
    }
    message = json['message'];
  }
}
