import 'group_latest_message.dart';

class GroupCreateResponse {
  int? success;
  GroupLatestMessage? grup;
  String? message;

  GroupCreateResponse(
      {required this.success, required this.grup, required this.message});

  factory GroupCreateResponse.fromJson(Map<String, dynamic> json) {
    if (json['grup'] is Map<String, dynamic>) {
      return GroupCreateResponse(
        success: json['success'],
        grup: GroupLatestMessage.fromJson(json['grup']),
        message: json['message'],
      );
    } else {
      return GroupCreateResponse(
        success: 0,
        grup: GroupLatestMessage(),
        message: "Hata Oluştu: Grup bilgisi beklenen formatta değil",
      );
    }
  }
}
