import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/color_constants.dart';

class EmployeeNavigateButton extends StatelessWidget {
  final String buttonTxt;
  final void Function()? withOnPressed;
  const EmployeeNavigateButton(
      {super.key, required this.buttonTxt, this.withOnPressed});

  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: context.dynamicHeight(0.045),
      width: context.dynamicWidth(0.25),
      child: TextButton(
        onPressed: withOnPressed,
        style: TextButton.styleFrom(
          backgroundColor: ColorsConstants.instance.baseTheme,
        ),
        child: Text(
          buttonTxt,
          style: const TextStyle(color: Colors.white),
        ),
      ),
    );
  }
}
