import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/human_resources/cubit/employee_cubit.dart';
import 'package:hamlemuhcrm/features/human_resources/model/personel.dart';
import 'package:hamlemuhcrm/features/human_resources/view/employee_update_page.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/constants/url_services_constant.dart';

class EmployeeArchivePage extends StatelessWidget {
  const EmployeeArchivePage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        title: Text('Personel Listesi IK Arşivler',
            style: GoogleFonts.inter(
                color: Colors.black,
                fontWeight: FontWeight.w400,
                fontSize: 16)),
        centerTitle: true,
        leading: IconButton(
          onPressed: () {
            context
                .read<EmployeeCubit>()
                .personelListele(
                    context.read<LoginCubit>().userfirmId,
                    context.read<LoginCubit>().token,
                    context.read<LoginCubit>().id)
                .whenComplete(() =>
                    Navigator.popUntil(context, (route) => route.isFirst));
          },
          icon: const Icon(
            Icons.arrow_back_ios_new,
            color: Colors.black87,
          ),
        ),
      ),
      body: Center(
        child: Column(
          children: [
            SizedBox(
                height: context.dynamicHeight(0.2),
                child: ImageEnums.employee.toPageImage),
            SizedBox(height: context.dynamicHeight(0.02)),
            Expanded(
              flex: 3,
              child: SizedBox(
                height: context.dynamicHeight(0.59),
                child: BlocBuilder<EmployeeCubit, List<Personel>>(
                    builder: (context, personel) {
                  if (personel.isNotEmpty) {
                    return ListView.builder(
                        itemCount: personel.length,
                        itemBuilder: (context, indeks) {
                          final fPersonel = personel[indeks];
                          return InkWell(
                            highlightColor: Colors.grey.shade50,
                            onTap: () {
                              Navigator.push(
                                  context,
                                  MaterialPageRoute(
                                      builder: (context) => EmployeeUpdatePage(
                                          personel: fPersonel)));
                            },
                            child: Container(
                              height: context.dynamicHeight(0.09),
                              margin: EdgeInsets.symmetric(
                                  vertical: context.dynamicHeight(0.01),
                                  horizontal: context.dynamicWidth(0.04)),
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(5),
                                boxShadow: [
                                  BoxShadow(
                                      color: Colors.grey.withOpacity(0.4),
                                      blurRadius: 7,
                                      offset: const Offset(1, 5))
                                ],
                                color: Colors.white,
                              ),
                              child: Row(
                                children: [
                                  Container(
                                    width: 5,
                                    height: context.dynamicHeight(0.09),
                                    decoration: const BoxDecoration(
                                      borderRadius: BorderRadius.only(
                                          topLeft: Radius.circular(5),
                                          bottomLeft: Radius.circular(5)),
                                      color: Colors.grey,
                                    ),
                                  ),
                                  const SizedBox(width: 10),
                                  Text(
                                      '${fPersonel.firstName!} ${fPersonel.lastName!}',
                                      style: FontStyles.instance.ortaYazi),
                                  const Spacer(),
                                  Container(
                                    margin: EdgeInsets.only(
                                        right: context.dynamicWidth(0.04)),
                                    width: context.dynamicWidth(0.14),
                                    height: context.dynamicHeight(0.06),
                                    child: Stack(
                                      alignment: Alignment.centerLeft,
                                      children: [
                                        CircleAvatar(
                                          radius: 20,
                                          backgroundColor: Colors.grey.shade400,
                                          child: CachedNetworkImage(
                                            imageUrl: _imageCheck(fPersonel),
                                            imageBuilder:
                                                (context, imageProvider) =>
                                                    Container(
                                              decoration: BoxDecoration(
                                                shape: BoxShape.circle,
                                                image: DecorationImage(
                                                    image: imageProvider,
                                                    fit: BoxFit.cover),
                                              ),
                                            ),
                                            errorWidget:
                                                (context, url, error) => Icon(
                                              Icons
                                                  .image_not_supported_outlined,
                                              color: ColorsConstants.instance
                                                  .containerBorderGreyColor,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          );
                        });
                  } else {
                    return const Center(
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          SizedBox(height: 25),
                          Text(
                            'Kişi Bulunamadı',
                            style: TextStyle(fontSize: 17),
                          ),
                        ],
                      ),
                    );
                  }
                }),
              ),
            )
          ],
        ),
      ),
    );
  }
}

String _imageCheck(Personel model) {
  if (model.image == null) return URLAPIService.instance.defaultPhotoUrl;

  if (model.image != null && model.image!.isNotEmpty) {
    return '${URLAPIService.instance.fileBaseURL}/upload-user/${model.image}';
  }

  return URLAPIService.instance.defaultPhotoUrl;
}
