import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/data/repo/employee_repository.dart';
import 'package:hamlemuhcrm/features/human_resources/model/personel.dart';

class EmployeeCubit extends Cubit<List<Personel>> {
  EmployeeCubit() : super(<Personel>[]);

  var repo = EmployeeRepository();

  List<Personel> personeller = [];
  List<Personel> arsivPersoneller = [];

  Future<void> personelListele(
      String userUserfirmId, String token, String loginuserid) async {
    var liste = await repo.personelListesi(userUserfirmId, token, loginuserid);
    personeller.clear();
    personeller.addAll(liste ?? []);
    emit(List<Personel>.from(personeller));
  }

  Future<void> personelArsivListele(
      String userUserfirmId, String token, String loginuserid) async {
    var liste =
        await repo.personelArsivListesi(userUserfirmId, token, loginuserid);
    arsivPersoneller = liste ?? [];
    emit(arsivPersoneller);
  }

  Future<void> personelArsivle(
      String arsivlenecekUserId, String token, String loginuserid) async {
    await repo.personelArsivle(arsivlenecekUserId, token, loginuserid);
  }

  Future<void> personelArsivdenCikar(String arsivdenCikarilacakUserId,
      String token, String loginuserid) async {
    await repo.personelArsivdenCikar(
        arsivdenCikarilacakUserId, token, loginuserid);
  }

  Future<void> personelEkle(
    String userUserfirmId,
    String firstName,
    String lastName,
    String email,
    String password,
    String ceptelefon,
    String userDataAdres,
    String userdataIseGirisTarihi,
    String userdataTcKimlik,
    String userdataAskerlikDurumu,
    String unvanId,
    String token,
    String loginuserid,
    String loginusertype,
  ) async {
    await repo.personelEkle(
        userUserfirmId,
        firstName,
        lastName,
        email,
        password,
        ceptelefon,
        userDataAdres,
        userdataIseGirisTarihi,
        userdataTcKimlik,
        userdataAskerlikDurumu,
        unvanId,
        token,
        loginuserid,
        loginusertype);
  }

  Future<void> personelGuncelle(
    String guncellenecekID,
    String userUserfirmId,
    String firstName,
    String lastName,
    String email,
    String password,
    String ceptelefon,
    String userDataAdres,
    String userdataIseGirisTarihi,
    String userdataTcKimlik,
    String userdataAskerlikDurumu,
    String unvanId,
    String token,
    String loginuserid,
    String loginusertype,
  ) async {
    await repo.personelGuncelle(
        guncellenecekID,
        userUserfirmId,
        firstName,
        lastName,
        email,
        password,
        ceptelefon,
        userDataAdres,
        userdataIseGirisTarihi,
        userdataTcKimlik,
        userdataAskerlikDurumu,
        unvanId,
        token,
        loginuserid,
        loginusertype);
  }

  void personelAra(String searchKey) async {
    var liste = <Personel>[];
    for (var element in personeller) {
      if (element.firstName!.toLowerCase().contains(searchKey.toLowerCase()) ||
          element.lastName!.toLowerCase().contains(searchKey.toLowerCase())) {
        liste.add(element);
      }
    }
    emit(liste);
  }
}
