import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/color_constants.dart';

class SearchCustomWidget extends StatefulWidget {
  final bool golge;
  final Color arkaplan;
  final TextEditingController tc;
  final bool isActive;

  const SearchCustomWidget(
      {super.key,
      required this.golge,
      required this.arkaplan,
      required this.tc,
      required this.isActive});

  @override
  State<SearchCustomWidget> createState() => _SearchCustomWidgetState();
}

class _SearchCustomWidgetState extends State<SearchCustomWidget> {
  @override
  Widget build(BuildContext context) {
    return Container(
      height: context.dynamicHeight(0.0564),
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(8),
          color: ColorsConstants.instance.backgroundColor,
          boxShadow: [
            BoxShadow(
                color: widget.golge
                    ? Colors.grey.withOpacity(0.4)
                    : Colors.transparent,
                blurRadius: 6,
                offset: const Offset(1, 1)),
          ],
          border: Border.all(color: Colors.grey.withOpacity(0.3))),
      child: Row(
        children: [
          Flexible(
            flex: 2,
            child: TextFormField(
              controller: widget.tc,
              textAlign: TextAlign.left,
              enabled: widget.isActive,
              magnifierConfiguration: TextMagnifierConfiguration.disabled,
              style: const TextStyle(color: Colors.grey, fontSize: 16.0),
              decoration: InputDecoration(
                  focusedBorder:
                      const OutlineInputBorder(borderSide: BorderSide.none),
                  border: const OutlineInputBorder(borderSide: BorderSide.none),
                  contentPadding: const EdgeInsets.symmetric(horizontal: 5),
                  prefixIcon: Icon(
                    Icons.search,
                    color: Colors.grey,
                    size: context.dynamicWidth(0.062),
                  ),
                  hintText: 'Arama',
                  hintStyle:
                      const TextStyle(fontSize: 15.0, color: Colors.grey)),
            ),
          ),
        ],
      ),
    );
  }
}
