import 'package:flutter/material.dart';
import 'package:syncfusion_flutter_charts/charts.dart';

class PieChart extends StatelessWidget {
  const PieChart({super.key});

  @override
  Widget build(BuildContext context) {
    return SfCircularChart(
        title: ChartTitle(
            text: 'Çalışan Dağılımları',
            alignment: ChartAlignment.near,
            textStyle: Theme.of(context).textTheme.headlineSmall),
        legend: const Legend(isVisible: true),
        series: <PieSeries<PieData, String>>[
          PieSeries<PieData, String>(
              explode: true,
              explodeIndex: 0,
              dataSource: pieData,
              xValueMapper: (PieData data, _) => data.xData,
              yValueMapper: (PieData data, _) => data.yData,
              dataLabelMapper: (PieData data, _) => data.text,
              dataLabelSettings: const DataLabelSettings(isVisible: true)),
        ]);
  }
}

class PieData {
  PieData(this.xData, this.yData, this.text);
  final String xData;
  final num yData;
  final String text;
}

final List<PieData> pieData = [
  PieData('Mühendis', 30, '30%'),
  PieData('Arge', 20, '20%'),
  PieData('Bilgi İşlem', 15, '15%'),
  PieData('Tekniker', 10, '10%'),
  PieData('İdari Birim', 25, '25%'),
];
