import 'package:flutter/material.dart';

import '../../../core/constants/color_constants.dart';
import '../../../core/extensions/responsive_extension.dart';

class FavoritesList extends StatelessWidget {
  final Icon icon;
  final void Function()? onTap;
  final Color iconarkaplan;
  final String title;
  final String subtitle;

  const FavoritesList({
    super.key,
    required this.onTap,
    required this.icon,
    required this.iconarkaplan,
    required this.title,
    required this.subtitle,
  });

  @override
  Widget build(BuildContext context) {
    final textTheme = Theme.of(context).textTheme;
    return GestureDetector(
      onTap: onTap,
      child: Container(
        height: context.dynamicHeight(0.14),
        width: context.dynamicWidth(0.444),
        padding: EdgeInsets.symmetric(
            horizontal: context.dynamicWidth(0.04),
            vertical: context.dynamicHeight(0.017)),
        decoration: BoxDecoration(
          boxShadow: [
            BoxShadow(
                color: Colors.grey.withOpacity(0.4),
                blurRadius: 6,
                offset: const Offset(2.8, 3.5))
          ],
          borderRadius: BorderRadius.circular(15),
          color: Colors.white,
        ),
        child: Column(children: [
          Row(
            children: [
              Container(
                  height: context.dynamicHeight(0.04),
                  width: context.dynamicHeight(0.04),
                  decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10),
                      color: iconarkaplan.withOpacity(0.14)),
                  child: icon),
            ],
          ),
          const Spacer(),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(title, style: textTheme.bodySmall),
                  _emptyHeightSpace(context),
                  Text(
                    subtitle,
                    style: const TextStyle(fontSize: 12, color: Colors.black26),
                  ),
                ],
              ),
              _navigateIconButton,
            ],
          ),
        ]),
      ),
    );
  }

  Widget _emptyHeightSpace(BuildContext context) {
    return SizedBox(
      height: context.dynamicHeight(0.006),
    );
  }

  Widget get _navigateIconButton => Icon(
        Icons.arrow_circle_right_outlined,
        color: ColorsConstants.instance.baseTheme,
        size: 20,
      );
}
