import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../../core/constants/app_constants.dart';
import '../../../core/extensions/date_time_enum_extension.dart';
import '../../../core/extensions/responsive_extension.dart';
import '../../auth/login/cubit/login_cubit.dart';
import '../../calendar/cubit/calendar_cubit.dart';
import '../../calendar/cubit/calendar_state.dart';
import '../cubit/home_custom_cubit.dart';
import '../widgets/favorites_list.dart';

class Homepage extends StatefulWidget {
  const Homepage({super.key});

  @override
  State<Homepage> createState() => _HomepageState();
}

class _HomepageState extends State<Homepage> {
  @override
  void initState() {
    debugPrint('kayitli TOken : ${context.read<LoginCubit>().token}');
    debugPrint('kayitli UserID : ${context.read<LoginCubit>().id}');
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.035)),
      child: Column(
        children: [
          _profileInfo,
          const Expanded(
            flex: 1,
            child: SizedBox.expand(),
          ),
          Expanded(
            flex: 1,
            child: Row(
              children: [
                Text(ApplicationConstants.instance.favoritesListTxt,
                    style: Theme.of(context).textTheme.headlineSmall),
                const Spacer(),
                Text(
                  DateTimeEnums.tr.nowTime(),
                  style: const TextStyle(color: Colors.grey),
                ),
              ],
            ),
          ),
          Expanded(
            flex: 5,
            child: Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    FavoritesList(
                        iconarkaplan: Colors.orange,
                        icon: const Icon(
                          Icons.people,
                          color: Colors.orange,
                          size: 22,
                        ),
                        title:
                            ApplicationConstants.instance.customersModuleSubTxt,
                        // '${context.read<HomeCustomCubit>().musteriSayisi}
                        subtitle: '10+ Müşteri',
                        onTap: () => context
                            .read<HomeCustomCubit>()
                            .setSecilenBodyIndeks(3)),
                    FavoritesList(
                      onTap: () => context
                          .read<HomeCustomCubit>()
                          .setSecilenBodyIndeks(1),
                      iconarkaplan: Colors.blue,
                      icon:
                          const Icon(Icons.rule, color: Colors.blue, size: 22),
                      title: ApplicationConstants.instance.projectModuleTxt,
                      subtitle:
                          '${context.read<HomeCustomCubit>().projeSayisi} Proje',
                    ),
                  ],
                ),
                Expanded(
                  flex: 5,
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      BlocBuilder<CalendarCubit, CalendarState>(
                        builder: (context, state) => FavoritesList(
                          onTap: () => context
                              .read<HomeCustomCubit>()
                              .setSecilenBodyIndeks(2),
                          iconarkaplan: Colors.green,
                          icon: const Icon(Icons.edit_calendar_outlined,
                              color: Colors.green, size: 22),
                          title:
                              ApplicationConstants.instance.calendarModuleTxt,
                          subtitle: '${state.toplantiList.length} Toplantı',
                        ),
                      ),
                      FavoritesList(
                        onTap: () => context
                            .read<HomeCustomCubit>()
                            .setSecilenBodyIndeks(5),
                        iconarkaplan: Colors.yellow,
                        icon: const Icon(Icons.note_alt_outlined,
                            color: Color(0xFFF7B500), size: 22),
                        title: ApplicationConstants
                            .instance.humanResourcesModuleTxt,
                        subtitle: '0 Personel',
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
          const Expanded(flex: 5, child: SizedBox()),
          //const Expanded(flex: 5, child: PieChart()),
        ],
      ),
    );
  }

  Widget get _profileInfo => Row(
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          GestureDetector(
            onTap: () =>
                context.read<HomeCustomCubit>().setSecilenBodyIndeks(4),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  '${context.read<LoginCubit>().ad} ${context.read<LoginCubit>().soyad}',
                  style: const TextStyle(fontSize: 22),
                ),
                Text(
                    context.read<LoginCubit>().unvanAd == ''
                        ? 'Ünvan Yok '
                        : context.read<LoginCubit>().unvanAd,
                    style: const TextStyle(color: Colors.grey, height: 1))
              ],
            ),
          ),
        ],
      );
}
