import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/color_constants.dart';

class OrderWidthButton extends StatelessWidget {
  final String yazi;
  final bool kenarlik;

  const OrderWidthButton({
    super.key,
    required this.yazi,
    required this.kenarlik,
  });

  @override
  Widget build(BuildContext context) {
    final textTheme = Theme.of(context).textTheme;
    return Container(
      height: context.dynamicHeight(0.050),
      width: context.dynamicWidth(0.158),
      decoration: BoxDecoration(
        color: ColorsConstants.instance.backgroundColor
            .withOpacity(0.8), //arkaplan.withOpacity(0.8) default
        border: Border.all(color: Colors.grey.withOpacity(0.6)),
        borderRadius: BorderRadius.circular(10),
      ),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          Text(
            yazi,
            style: textTheme.labelSmall?.copyWith(color: Colors.grey.shade700),
          ),
        ],
      ),
    );
  }
}
