import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/customers/cubit/company_personal_cubit.dart';
import 'package:hamlemuhcrm/features/customers/view/companies/add_person_parametry.dart';

class OrangeBox extends StatelessWidget {
  final String id;
  final String firmaAd;

  const OrangeBox({super.key, required this.id, required this.firmaAd});

  @override
  Widget build(BuildContext context) {
    return Container(
      height: context.dynamicHeight(0.1863),
      decoration: BoxDecoration(
        color: ColorsConstants.instance.baseTheme,
        borderRadius: BorderRadius.circular(20),
      ),
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.04)),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: [
            Row(
              children: [
                Expanded(
                  child: InkWell(
                    highlightColor: Colors.grey.shade50,
                    onTap: () {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => AddPersonParametry(
                                    id: id,
                                    firmaAd: firmaAd,
                                    durum: 1,
                                  )));
                    },
                    child: Container(
                      height: context.dynamicHeight(0.06),
                      decoration: BoxDecoration(
                          color: const Color(0xFFFFFFFF),
                          borderRadius: BorderRadius.circular(8),
                          border: Border.all(
                              color: Colors.grey.withOpacity(0.4), width: 1.0)),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Padding(
                            padding: const EdgeInsets.only(left: 7),
                            child: Icon(
                              Icons.person_add_alt_1_rounded,
                              color: ColorsConstants.instance.baseTheme,
                              size: 20,
                            ),
                          ),
                          const SizedBox(width: 10),
                          const Text(
                            'Kişi Ekle',
                            style: TextStyle(fontSize: 15),
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
              ],
            ),
            Container(
              height: context.dynamicHeight(0.06),
              padding: const EdgeInsets.symmetric(horizontal: 6),
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                        color: Colors.grey.withOpacity(0.4),
                        blurRadius: 6,
                        offset: const Offset(1, 1))
                  ],
                  border: Border.all(
                      color: Colors.grey.withOpacity(0.4), width: 1.0)),
              child: Row(
                children: [
                  Flexible(
                    flex: 2,
                    child: TextFormField(
                      style: const TextStyle(color: Colors.grey),
                      magnifierConfiguration:
                          TextMagnifierConfiguration.disabled,
                      onChanged: (value) {
                        context.read<CompanyPersonalCubit>().yetkiliAra(value);
                      },
                      decoration: const InputDecoration(
                          focusedBorder:
                              OutlineInputBorder(borderSide: BorderSide.none),
                          border:
                              OutlineInputBorder(borderSide: BorderSide.none),
                          icon: Icon(
                            Icons.search,
                            color: Colors.grey,
                            size: 22,
                          ),
                          contentPadding:
                              EdgeInsets.symmetric(horizontal: 2.00),
                          hintText: 'Arama',
                          hintStyle:
                              TextStyle(fontSize: 16, color: Colors.grey)),
                    ),
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
