import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

class NavigateWidthButton extends StatelessWidget {
  final String yazi;
  final IconData icon;
  final Color iconrenk;
  final bool kenarlik;

  const NavigateWidthButton({
    super.key,
    required this.yazi,
    required this.icon,
    required this.iconrenk,
    required this.kenarlik,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: context.dynamicHeight(0.091),
      width: context.dynamicWidth(0.258),
      decoration: BoxDecoration(
        color: iconrenk.withOpacity(0.24),
        border: kenarlik
            ? Border.all(color: Colors.grey.withOpacity(0.3))
            : Border.all(color: Colors.transparent),
        borderRadius: BorderRadius.circular(15),
      ),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          Icon(icon, color: iconrenk),
          Text(
            yazi,
            style: const TextStyle(fontSize: 13, color: Colors.black38),
          ),
        ],
      ),
    );
  }
}
