import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/app_constants.dart';
import 'package:hamlemuhcrm/features/customers/cubit/customers_cubit.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/color_constants.dart';

class InterViewTypeDD extends StatefulWidget {
  final bool isShadow;
  final bool isShort;

  const InterViewTypeDD(
      {super.key, required this.isShadow, required this.isShort});

  @override
  State<InterViewTypeDD> createState() => _InterViewTypeDDState();
}

class _InterViewTypeDDState extends State<InterViewTypeDD> {
  late String selectedValue;

  final Map<String, String> keyValues = ApplicationConstants.instance.callType;

  @override
  void initState() {
    selectedValue = context.read<CustomersCubit>().secilenGorusmeTipi;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return DropdownButtonHideUnderline(
      child: DropdownButton2(
        isExpanded: true,
        value: selectedValue,
        items: keyValues.entries
            .map((entry) => DropdownMenuItem<String>(
                  value: entry.key,
                  child: Text(
                    entry.value,
                    style: FontStyles.instance.meetGeneralStyle,
                  ),
                ))
            .toList(),
        onChanged: (value) {
          selectedValue = value ?? '';
          setState(() {
            context.read<CustomersCubit>().secilenGorusmeTipi = selectedValue;
          });
          debugPrint(
              'Secilen Deger Cubit : ${context.read<CustomersCubit>().secilenGorusmeTipi}');
        },
        buttonStyleData: ButtonStyleData(
          height: context.dynamicHeight(0.05),
          width: context.dynamicWidth(widget.isShort ? 0.42 : 0.9),
          padding: const EdgeInsets.symmetric(horizontal: 10),
          decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10),
              border: widget.isShadow
                  ? null
                  : Border.all(color: Colors.grey.shade400),
              color: Colors.white,
              boxShadow: [
                widget.isShadow
                    ? BoxShadow(
                        color: Colors.grey.withOpacity(0.3),
                        offset: const Offset(0.4, 0.3),
                        blurRadius: 7)
                    : const BoxShadow() //null
              ]),
          elevation: 0,
        ),
        iconStyleData: IconStyleData(
          icon: const Icon(
            Icons.keyboard_arrow_down_outlined, //ilk icon
          ),
          openMenuIcon: const Icon(
              Icons.keyboard_arrow_left_outlined), //açıldıktan sonraki icon
          iconSize: 23,
          iconEnabledColor: ColorsConstants.instance.baseTheme,
          iconDisabledColor: Colors.white,
        ),
        dropdownStyleData: DropdownStyleData(
          maxHeight: context.dynamicHeight(0.17),
          isOverButton: false,
          padding: null,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10),
            color: ColorsConstants
                .instance.backgroundColor, //açılır menü arkaplan rengi
          ),
          elevation: 8,
          offset: const Offset(0, 0),
          scrollbarTheme: ScrollbarThemeData(
            thumbColor: MaterialStateColor.resolveWith((states) =>
                ColorsConstants
                    .instance.baseTheme), //dropdown scroll rengi değiştirme
            radius: const Radius.circular(10),
            thickness: MaterialStateProperty.all<double>(6),
            thumbVisibility: MaterialStateProperty.all<bool>(true),
          ),
        ),
        menuItemStyleData: const MenuItemStyleData(
          height: 35,
          padding: EdgeInsets.symmetric(horizontal: 14),
        ),
      ),
    );
  }
}
