import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/color_constants.dart';

class IntTextField extends StatefulWidget {
  final String aciklama;
  final double yukseklik;
  final int satirSayisi;
  final bool kenarlik;
  final bool golge;
  final Color arkaplanRengi;
  final bool tekSatirMi;
  final TextEditingController textEditingController;
  final int kisitlama;

  const IntTextField(
      {super.key,
      required this.aciklama,
      required this.yukseklik,
      required this.satirSayisi,
      required this.kenarlik,
      required this.golge,
      required this.arkaplanRengi,
      required this.tekSatirMi,
      required this.textEditingController,
      required this.kisitlama});

  @override
  State<IntTextField> createState() => _IntTextFieldState();
}

class _IntTextFieldState extends State<IntTextField> {
  @override
  Widget build(BuildContext context) {
    return Container(
      height: widget.yukseklik,
      padding: widget.tekSatirMi
          ? const EdgeInsets.symmetric(vertical: 4, horizontal: 4)
          : const EdgeInsets.symmetric(horizontal: 4),
      alignment: Alignment.center,
      decoration: BoxDecoration(
          color: widget.arkaplanRengi,
          borderRadius: BorderRadius.circular(10),
          border: widget.kenarlik
              ? Border.all(color: Colors.grey.withOpacity(0.2), width: 1.1)
              : Border.all(color: Colors.transparent),
          boxShadow: [
            BoxShadow(
                color: widget.golge
                    ? Colors.grey.withOpacity(0.22)
                    : Colors.transparent,
                blurRadius: 4,
                offset: const Offset(0, 4))
          ]),
      child: TextFormField(
          controller: widget.textEditingController,
          maxLines: widget.satirSayisi,
          textInputAction: TextInputAction.next,
          magnifierConfiguration: TextMagnifierConfiguration.disabled,
          cursorColor: ColorsConstants.instance.baseTheme,
          validator: (value) {
            if (value!.isEmpty ||
                !RegExp(r'^[+]*[(]{0,1}[0-9]{1,4}[)]{0,1}[-\s\./0-9]*$')
                    .hasMatch(value)) {
              return '';
            } else {
              return null;
            }
          },
          inputFormatters: [LengthLimitingTextInputFormatter(widget.kisitlama)],
          style: const TextStyle(
              color: Colors.grey,
              fontSize: 14.0,
              overflow: TextOverflow.visible),
          decoration: InputDecoration(
              border: InputBorder.none,
              contentPadding: EdgeInsets.symmetric(
                  horizontal: context.dynamicWidth(0.02),
                  vertical: context.dynamicHeight(0.01)),
              isDense: true)),
    );
  }
}
