import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/color_constants.dart';
import '../../projects/model/filter_chip.dart';

class FilterActivitiesChip extends StatefulWidget {
  const FilterActivitiesChip({super.key});

  @override
  State<FilterActivitiesChip> createState() => _FilterActivitiesChipState();
}

class _FilterActivitiesChipState extends State<FilterActivitiesChip> {
  List<FilterChipModel> filterList = [
    FilterChipModel(index: 0, name: 'Başlık (A-Z)'),
    FilterChipModel(index: 1, name: 'Firma Adı(A-Z)'),
    FilterChipModel(index: 2, name: 'Tarih'),
  ];

  ValueNotifier<int> activeIndex = ValueNotifier<int>(3);

  @override
  Widget build(BuildContext context) {
    final textTheme = Theme.of(context).textTheme;
    return Row(mainAxisAlignment: MainAxisAlignment.spaceEvenly, children: [
      ...List.generate(3, (index) {
        var chip = filterList[index];
        return ValueListenableBuilder(
          valueListenable: activeIndex,
          builder: (context, notifierValue, child) => Material(
            color: Colors.transparent,
            child: InkWell(
              onTap: () {
                'activeIndex : ${activeIndex.value}'.log();
                'chipIndex : ${chip.index}'.log();
                activeIndex.value = chip.index;
              },
              splashColor: Colors.black.withOpacity(0.5),
              borderRadius: BorderRadius.circular(10),
              child: button(textTheme, activeIndex.value, chip.index,
                  filterList[index].name),
            ),
          ),
        );
      })
    ]);
  }

  Widget button(TextTheme theme, int currentIndex, int chipIndex, String txt) =>
      Container(
        height: context.dynamicHeight(0.046),
        width: context.dynamicWidth(0.25),
        decoration: BoxDecoration(
          color: currentIndex == chipIndex
              ? ColorsConstants.instance.baseTheme.withOpacity(0.8)
              : ColorsConstants.instance.backgroundColor,
          border: Border.all(color: Colors.grey.withOpacity(0.6)),
          borderRadius: BorderRadius.circular(10),
        ),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: [
            Text(
              txt,
              style: theme.titleSmall?.copyWith(
                  color: currentIndex == chipIndex
                      ? Colors.white
                      : Colors.grey.shade700),
            ),
          ],
        ),
      );
}
