import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/core/route/page_route.dart';
import 'package:hamlemuhcrm/features/customers/view/customers_page_view.dart';

import 'activities/create_activity.dart';
import 'companies/create_company.dart';

mixin CustomerPageMixin on State<CustomersPageView> {
  late TabController tabController2;

  late bool isFinish;

  static GlobalKey<FormState> searchKey =
      GlobalKey(); //bu problemi kısmen çözdü ancak bazı sorunlar devam ediyor alttaki initial ındex = 0 kaldırılabilir...............

  void changeTabBar(int index) {
    setState(() {
      if (index == 0) {
        firmaButonumu = true;
        tariheGoreSirala = false;
      } else {
        firmaButonumu = false;
      }
    });
  }

  /// Tabbar indexine müdahale edildi. arşivledikten sonra geri gelip aktiviteler sayfası görüntülenmeli en başa atmamalı düzeltilecek...
  void onTabChange();

  @override
  void dispose() {
    tcfirmaAra.dispose();
    tcaktiviteAra.dispose();
    tabController2.dispose();
    super.dispose();
  }

  final TextEditingController tcfirmaAra = TextEditingController();
  final TextEditingController tcaktiviteAra = TextEditingController();
  bool tariheGoreSirala = false;
  bool isProcessing = false;
  String dbSaatbaslangic = '';
  String dbSaatbitis = '';
  String gosterilenSaatbaslangic = '';
  String gosterilenSaatbitis = '';
  DateTime birincidateTime = DateTime.now();
  DateTime ikincidateTime = DateTime.now();
  bool baslangicSecildi = false;
  bool tarihUygun = false;

  void handleButtonActivity();

  void handleButtonCompany();

  bool firmArsivMi = false;
  bool aktiviteArsivMi = false;
  bool firmaButonumu = true;
  bool aramaYapiliyor = false;

  void navigateToCreateCompany() {
    Navigator.push(context, CustomPageRoute(child: const CreateCompany()));
  }

  void navigateToCreateActivity() {
    Navigator.push(context, CustomPageRoute(child: const CreateActivity()));
  }

  Widget widthButton(String text, Color renk, IconData iconData) {
    return Container(
      height: context.dynamicHeight(0.091),
      width: context.dynamicWidth(0.258),
      decoration: BoxDecoration(
        color: renk.withOpacity(0.24),
        border: Border.all(color: Colors.grey.withOpacity(0.3)),
        borderRadius: BorderRadius.circular(15),
      ),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          Icon(iconData, color: renk),
          Text(
            text,
            style: const TextStyle(fontSize: 13, color: Colors.black38),
          ),
        ],
      ),
    );
  }
}
