import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/features/customers/cubit/company_personal_cubit.dart';
import 'package:hamlemuhcrm/features/customers/view/activities/create_activity.dart';
import 'package:hamlemuhcrm/features/auth/login/cubit/login_cubit.dart';
import 'package:hamlemuhcrm/features/customers/widgets/int_textfield.dart';
import 'package:hamlemuhcrm/features/customers/widgets/string_textfield.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../../core/constants/app_constants.dart';
import '../../../../core/constants/color_constants.dart';
import '../../../../core/utility/toast_manager.dart';

class AddPersonParametry extends StatefulWidget {
  final String id;
  final String firmaAd;
  final int
      durum; //durum 1 ise standart kisi ekleme sayfasıdır 2 ise aktivite oluşturdan 3 ise firmanın aktivite güncellemesinden gelinmiştir..

  const AddPersonParametry(
      {super.key,
      required this.id,
      required this.firmaAd,
      required this.durum});
  @override
  State<AddPersonParametry> createState() => _AddPersonParametryState();
}

class _AddPersonParametryState extends State<AddPersonParametry> {
  final _personKey = GlobalKey<FormState>();

  var tcKisiAdSoyad = TextEditingController();
  var tcKisiBirim = TextEditingController();
  var tcKisiCepNo = TextEditingController();
  var tcKisiMail = TextEditingController();
  var tcKisiNot = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        title: Text('Kişi Ekle (${widget.firmaAd})',
            style: GoogleFonts.inter(
                color: Colors.black,
                fontWeight: FontWeight.w400,
                fontSize: 16)),
        centerTitle: true,
        actions: [
          IconButton(
              onPressed: () {},
              icon: const Icon(
                Icons.notifications_none_outlined,
                color: Colors.black,
              )),
        ],
        leading: IconButton(
            onPressed: () {
              Navigator.pop(context);
              widget.durum == 3
                  ? Navigator.popUntil(context, (route) => route.isFirst)
                  : null;
            },
            icon: const Icon(
              Icons.arrow_back_ios_new,
              color: Colors.black54,
              size: 20,
            )),
      ),
      body: SingleChildScrollView(
        child: Padding(
          padding:
              EdgeInsets.symmetric(horizontal: context.dynamicHeight(0.03)),
          child: Column(
            children: [
              const SizedBox(height: 4),
              Container(
                width: context.dynamicWidth(1),
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(15),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colors.grey.withOpacity(0.2),
                        blurRadius: 7,
                        offset: const Offset(4, 5),
                      )
                    ]),
                child: Padding(
                  padding:
                      const EdgeInsets.symmetric(vertical: 10, horizontal: 17),
                  child: Form(
                    key: _personKey,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        SizedBox(
                            height: context.dynamicHeight(0.2),
                            child: ImageEnums.employee.toPageImage),
                        _emptySpace,
                        _headLine('Ad Soyad'),
                        _emptySpace,
                        StringTextField(
                          textEditingController: tcKisiAdSoyad,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 30,
                        ),
                        _emptySpace,
                        _headLine('İlgili Birim'),
                        _emptySpace,
                        StringTextField(
                          textEditingController: tcKisiBirim,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 37,
                        ),
                        _emptySpace,
                        _headLine('Mail Adresi'),
                        _emptySpace,
                        StringTextField(
                          textEditingController: tcKisiMail,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 70,
                        ),
                        _emptySpace,
                        _headLine('Cep No'),
                        _emptySpace,
                        IntTextField(
                          textEditingController: tcKisiCepNo,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.05),
                          satirSayisi: 1,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: true,
                          kisitlama: 11,
                        ),
                        _emptySpace,
                        _headLine('Adres'),
                        _emptySpace,
                        StringTextField(
                          textEditingController: tcKisiNot,
                          aciklama: '',
                          yukseklik: context.dynamicHeight(0.09),
                          satirSayisi: 3,
                          kenarlik: true,
                          golge: false,
                          arkaplanRengi:
                              ColorsConstants.instance.backgroundColor,
                          tekSatirMi: false,
                          kisitlama: 100,
                        ),
                        const SizedBox(height: 14),
                        Container(
                          height: context.dynamicHeight(0.05),
                          decoration: BoxDecoration(
                              color: ColorsConstants.instance.baseTheme,
                              borderRadius: BorderRadius.circular(10),
                              boxShadow: [
                                BoxShadow(
                                  color: Colors.grey.withOpacity(0.4),
                                  blurRadius: 8,
                                  offset: const Offset(1, 1),
                                )
                              ]),
                          child: TextButton(
                              onPressed: () {
                                if (_personKey.currentState!.validate()) {
                                  context
                                      .read<CompanyPersonalCubit>()
                                      .yetkiliEkle(
                                          widget.id,
                                          context.read<LoginCubit>().userfirmId,
                                          tcKisiAdSoyad.text,
                                          tcKisiBirim.text,
                                          tcKisiCepNo.text,
                                          tcKisiMail.text,
                                          tcKisiNot.text,
                                          context.read<LoginCubit>().id,
                                          context.read<LoginCubit>().token);
                                  ToastManager.instance.toastMessageService(
                                      "${tcKisiAdSoyad.text} Kişi Eklendi");
                                  Future.delayed(
                                      const Duration(milliseconds: 800), () {
                                    widget.durum == 1
                                        ? setState(() {
                                            Navigator.pop(context);
                                          })
                                        : {
                                            widget.durum == 2
                                                ? Navigator.pushReplacement(
                                                    context,
                                                    MaterialPageRoute(
                                                        builder: (context) =>
                                                            const CreateActivity()))
                                                : null,
                                          };
                                  });
                                }
                              },
                              style: TextButton.styleFrom(
                                  backgroundColor: Colors.transparent,
                                  shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.circular(10),
                                  )),
                              child: Padding(
                                padding: const EdgeInsets.symmetric(
                                    horizontal: 10.0),
                                child: Text(
                                  ApplicationConstants.instance.moduleSaveTxt,
                                  style: const TextStyle(color: Colors.white),
                                ),
                              )),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
              _emptySpace,
            ],
          ),
        ),
      ),
    );
  }
}

Widget get _emptySpace => const SizedBox(height: 6);

Widget _headLine(String headline) {
  return Row(
    mainAxisAlignment: MainAxisAlignment.start,
    children: [
      Text(
        headline,
        style: const TextStyle(color: Colors.grey, fontSize: 11),
      ),
    ],
  );
}
