import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/features/customers/view/activities/company_activity_page.dart';

import '../../../../auth/login/cubit/login_cubit.dart';
import '../../../cubit/activity_cubit.dart';

mixin CompanyActivityMixin on State<CompanyActivityPage> {
  final TextEditingController tfFirmaAktiviteAra = TextEditingController();
  late bool isFinish;
  @override
  void initState() {
    super.initState();
    isFinish = false;
    context
        .read<ActivityCubit>()
        .firmaAktiviteleriListele(
            widget.firma.firmaId,
            context.read<LoginCubit>().token,
            context.read<LoginCubit>().id,
            context.read<LoginCubit>().userfirmId,
            context.read<LoginCubit>().tip,
            1)
        .whenComplete(() {
      setState(() {
        aktiviteYok = context.read<ActivityCubit>().aktiviteYok;
        isFinish = true;
      });
    });
  }

  @override
  void dispose() {
    tfFirmaAktiviteAra.dispose();
    super.dispose();
  }

  bool aktiviteYok = false;
  bool aktiviteArsivMi = false;
}
