import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

class SearchTfInputDecoration extends InputDecoration {
  final BuildContext context;
  SearchTfInputDecoration(this.context)
      : super(
            border: const OutlineInputBorder(borderSide: BorderSide.none),
            contentPadding: const EdgeInsets.symmetric(horizontal: 5),
            focusedBorder:
                const OutlineInputBorder(borderSide: BorderSide.none),
            prefixIcon: Icon(
              Icons.search,
              color: Colors.grey,
              size: context.dynamicWidth(0.062),
            ),
            hintText: 'Arama',
            hintStyle: const TextStyle(fontSize: 15.0, color: Colors.grey));
}
