class Firmalar {
  String firmaId;
  String firmaIsim;
  String firmaWeb;
  String firmaEmail;
  String firmaVergiDairesi;
  String firmaVergiNo;
  String firmaTelefon;
  String firmaBirincilAdresi;
  String firmaEkleyenUserId;
  String firmaIl;
  String firmaIlce;
  String firmaOnay;

  Firmalar({
    required this.firmaId,
    required this.firmaIsim,
    required this.firmaWeb,
    required this.firmaEmail,
    required this.firmaVergiDairesi,
    required this.firmaVergiNo,
    required this.firmaTelefon,
    required this.firmaBirincilAdresi,
    required this.firmaEkleyenUserId,
    required this.firmaIl,
    required this.firmaIlce,
    required this.firmaOnay,
  });

  factory Firmalar.fromJson(Map<String, dynamic> json) {
    return Firmalar(
      firmaId: json["firma_id"] as String,
      firmaIsim: json["firma_isim"] as String,
      firmaWeb: json["firma_web"] ?? 'girilmemiş',
      firmaEmail: json["firma_e_mail"] ?? 'girilmemiş',
      firmaVergiDairesi: json["firma_vergi_dairesi"] ?? 'girilmemiş',
      firmaVergiNo: json["firma_vergi_no"] ?? '1111111',
      firmaTelefon: json["firma_telefon"] ?? 'girilmemiş',
      firmaBirincilAdresi: json["firma_birincil_adresi"] ?? 'girilmemiş',
      firmaEkleyenUserId: json["firma_ekleyen_user_id"] ?? '0',
      firmaIl: json["firma_il"] ?? '0',
      firmaIlce: json["firma_ilce"] ?? '0',
      firmaOnay: json["firma_onay"] ?? '1',
    );
  }
}
