import 'package:equatable/equatable.dart';

import '../model/aktiviteler.dart';
class ActivityState extends Equatable {
  final List<Aktiviteler> aktiviteler;
  final bool isLoading;
  final bool isCorrect;
  final bool isError;
  final bool isComplete;

  const ActivityState({
    required this.aktiviteler,
    required this.isLoading,
    required this.isCorrect,
    required this.isError,
    required this.isComplete,
  });

  factory ActivityState.initial() {
    return const ActivityState(
      aktiviteler: <Aktiviteler>[],
      isLoading: false,
      isCorrect: false,
      isError: false,
      isComplete: false,
    );
  }

  ActivityState copyWith({
    List<Aktiviteler>? aktiviteler,
    bool? isLoading,
    bool? isCorrect,
    bool? isError,
    bool? isComplete,
  }) {
    return ActivityState(
      aktiviteler: aktiviteler ?? this.aktiviteler,
      isLoading: isLoading ?? this.isLoading,
      isCorrect: isCorrect ?? this.isCorrect,
      isError: isError ?? this.isError,
      isComplete: isComplete ?? this.isComplete,
    );
  }

  @override
  List<Object?> get props =>
      [aktiviteler,isLoading, isCorrect, isError, isComplete];
}
