import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../../core/constants/font_styles.dart';
import '../../../core/cubits/dropdown_cubit.dart';
import '../cubit/calendar_cubit.dart';

class SelectMeetManagerDropdown extends StatefulWidget {
  final String? initialManagerIdValue;

  const SelectMeetManagerDropdown({super.key, this.initialManagerIdValue});
  @override
  State<SelectMeetManagerDropdown> createState() =>
      _SelectMeetManagerDropdownState();
}

class _SelectMeetManagerDropdownState extends State<SelectMeetManagerDropdown> {
  String? _secilenToplantiYoneticiId;

  bool isFinish = false;

  @override
  void initState() {
    changeLoading();
    setInitialValue();
    changeLoading();
    super.initState();
  }

  void changeLoading() {
    setState(() {
      isFinish = !isFinish;
    });
  }

  void setInitialValue() {
    if (widget.initialManagerIdValue != null &&
        widget.initialManagerIdValue != '' &&
        widget.initialManagerIdValue != '0') {
      // Toplantı Yöneticisi Başlangıçta Kullanıcı Seçili Olarak Gelecek
      _secilenToplantiYoneticiId = widget.initialManagerIdValue;
      context.read<CalendarCubit>().secilenToplantiYoneticiID =
          widget.initialManagerIdValue!;
    }
  }

  @override
  Widget build(BuildContext context) {
    return !isFinish
        ? BlocBuilder<DropdownCubit, DropdownState>(
            builder: (context, state) {
              return DropdownButtonHideUnderline(
                child: DropdownButton2(
                  hint: Text(
                    "",
                    style: FontStyles.instance.meetGeneralStyle,
                  ), //Data1
                  isExpanded: true,
                  items: state.calisanlar.map((yonetici) {
                    return DropdownMenuItem(
                      value: yonetici.id,
                      onTap: () {
                        // burada yönetici  id'sini alıyoruz.
                        debugPrint(yonetici.id);
                      },
                      child: Text('${yonetici.firstName} ${yonetici.lastName}',
                          style: FontStyles.instance.meetGeneralStyle), //value
                    );
                  }).toList(),
                  value: _secilenToplantiYoneticiId,
                  onChanged: (newValue) {
                    setState(() {
                      _secilenToplantiYoneticiId = newValue.toString();
                      setCubitValues();
                      debugPrint(
                          "_secilen yonetıcıID == $_secilenToplantiYoneticiId");
                    });
                  },
                  buttonStyleData: ButtonStyleData(
                    height: context.dynamicHeight(0.05),
                    padding: const EdgeInsets.only(right: 10),
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(10),
                        color: Colors.white,
                        border: Border.all(color: Colors.grey.shade400)),
                  ),
                  iconStyleData: IconStyleData(
                    icon: const Icon(
                      Icons.keyboard_arrow_down_outlined, //ilk icon
                    ),
                    openMenuIcon: const Icon(Icons
                        .keyboard_arrow_left_outlined), //açıldıktan sonraki icon
                    iconSize: 23,
                    iconEnabledColor: ColorsConstants.instance.baseTheme,
                    iconDisabledColor: Colors.white,
                  ),
                  dropdownStyleData: DropdownStyleData(
                    maxHeight: context.dynamicHeight(0.17),
                    offset: const Offset(0, 0),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10),
                      color: ColorsConstants.instance
                          .backgroundColor, //açılır menü arkaplan rengi
                    ),
                    scrollbarTheme: ScrollbarThemeData(
                      thumbColor: MaterialStateColor.resolveWith((states) =>
                          ColorsConstants.instance
                              .baseTheme), //dropdown scroll rengi değiştirme
                      radius: const Radius.circular(10),
                      thickness: MaterialStateProperty.all<double>(6),
                      thumbVisibility: MaterialStateProperty.all<bool>(true),
                    ),
                  ),
                  menuItemStyleData: const MenuItemStyleData(
                    height: 35,
                    padding: EdgeInsets.symmetric(horizontal: 14),
                  ),
                ),
              );
            },
          )
        : Container(
            height: context.dynamicHeight(0.054),
            width: context.dynamicWidth(0.9),
            padding: const EdgeInsets.symmetric(horizontal: 10),
            decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: Colors.white,
                border: Border.all(color: Colors.grey.shade400)),
          );
  }

  void setCubitValues() {
    context.read<CalendarCubit>().secilenToplantiYoneticiID =
        _secilenToplantiYoneticiId ?? '';
  }
}
