import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../../../../core/constants/color_constants.dart';
import '../../../core/cubits/dropdown_cubit.dart';
import '../../../data/dropdown_models/personal_getdata_api.dart';

class MultiSelectCompanyEmployeeDropdown extends StatefulWidget {
  final List<String> items;
  const MultiSelectCompanyEmployeeDropdown({Key? key, required this.items})
      : super(key: key);

  @override
  State<StatefulWidget> createState() =>
      _MultiSelectCompanyEmployeeDropdownState();
}

class _MultiSelectCompanyEmployeeDropdownState
    extends State<MultiSelectCompanyEmployeeDropdown> {
  final String dialogTxt = 'Katılan Yetkilileri Seç';
  final String confirmTxt = 'Onayla';
  final String cancelTxt = 'İptal';
  List<String> mSelectedEmployeeItemsValues = [];

  void _itemChange(String itemValue, bool isSelected, String itemText,
      YetkiliDDModel model) {
    setState(() {
      if (isSelected) {
        mSelectedEmployeeItemsValues.add(itemValue);
        mSelectedEmployeeItemsValues.add(itemText);
        debugPrint(
            'eklenen yetkili: ${model.yetkiliId}, ${model.yetkiliAdSoyad}, ${model.yetkiliIlgiliBirim} ');
        context.read<DropdownCubit>().listeyeYetkiliEkle(YetkiliDDModel(
              yetkiliId: model.yetkiliId,
              yetkiliAdSoyad: model.yetkiliAdSoyad,
              yetkiliIlgiliBirim: model.yetkiliIlgiliBirim,
            ));
      } else {
        mSelectedEmployeeItemsValues.remove(itemValue);
        mSelectedEmployeeItemsValues.remove(itemText);
        debugPrint(
            'silinen yetkili : ${model.yetkiliId}, ${model.yetkiliAdSoyad}, ${model.yetkiliIlgiliBirim} ');
        context.read<DropdownCubit>().listedenYetkiliCikart(YetkiliDDModel(
            yetkiliId: model.yetkiliId,
            yetkiliAdSoyad: model.yetkiliAdSoyad,
            yetkiliIlgiliBirim: model.yetkiliIlgiliBirim));
      }
    });
  }

  void _cancel() {
    Navigator.pop(context);
  }

  void _submit() async {
    Navigator.pop(context, mSelectedEmployeeItemsValues);
  }

  void _loadSelectedValues() {
    List<String> selectedValues = [];

    for (var k in context.read<DropdownCubit>().state.secilenYetkililer) {
      selectedValues.add(k.yetkiliId);
    }

    if (selectedValues.isNotEmpty) {
      mSelectedEmployeeItemsValues.addAll(selectedValues);
    }
  }

  @override
  void initState() {
    super.initState();
    _loadSelectedValues();
    debugPrint("multi_select_company_employee initState çalıştı");
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<DropdownCubit, DropdownState>(
      builder: (context, state) {
        return AlertDialog(
          title: Text(
            dialogTxt,
          ),
          content: SingleChildScrollView(
            child: ListBody(
              children: state.yetkililer
                  .map((entry) => CheckboxListTile(
                        value: mSelectedEmployeeItemsValues
                            .contains(entry.yetkiliId),
                        title: Text(entry.yetkiliAdSoyad),
                        controlAffinity: ListTileControlAffinity.trailing,
                        activeColor: ColorsConstants.instance.baseTheme,
                        onChanged: (isChecked) {
                          _itemChange(
                              entry.yetkiliId,
                              isChecked!,
                              entry.yetkiliAdSoyad,
                              YetkiliDDModel(
                                  yetkiliId: entry.yetkiliId,
                                  yetkiliAdSoyad: entry.yetkiliAdSoyad,
                                  yetkiliIlgiliBirim:
                                      entry.yetkiliIlgiliBirim));
                        },
                      ))
                  .toList(),
            ),
          ),
          actions: [
            TextButton(
                onPressed: _cancel,
                style: ElevatedButton.styleFrom(
                    backgroundColor: ColorsConstants.instance.baseTheme),
                child: Text(
                  cancelTxt,
                  style: const TextStyle(color: Colors.white),
                )),
            ElevatedButton(
              onPressed: _submit,
              style: ElevatedButton.styleFrom(
                  backgroundColor: ColorsConstants.instance.baseTheme),
              child: Text(
                confirmTxt,
                style: const TextStyle(color: Colors.white),
              ),
            ),
          ],
        );
      },
    );
  }
}
