import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/constants/font_styles.dart';
import 'package:hamlemuhcrm/core/extensions/string_extension.dart';
import 'package:table_calendar/table_calendar.dart';

import '../../auth/login/cubit/login_cubit.dart';
import '../cubit/calendar_cubit.dart';

final class CustomTableCalendar extends StatefulWidget {
  const CustomTableCalendar({super.key});

  @override
  State<CustomTableCalendar> createState() => _CustomTableCalendarState();
}

class _CustomTableCalendarState extends State<CustomTableCalendar> {
  var focusDayVarialable = DateTime.now();
  late DateTime selectedDayVarialable;
  late DateTime currentTime;
  late DateTime firstDayOfMonth;
  late DateTime lastDayOfMonth;

  @override
  void initState() {
    selectedDayVarialable = DateTime(1);
    currentTime = DateTime.now();
    firstDayOfMonth = _getFirstDayOfMonth(currentTime);
    lastDayOfMonth = _getLastDayOfMonth(currentTime);
    super.initState();
  }

  // Verilen tarihin ayın ilk gününü döndüren yardımcı işlev
  DateTime _getFirstDayOfMonth(DateTime date) {
    return DateTime(date.year, date.month, 1);
  }

  // Verilen tarihin ayın son gününü döndüren yardımcı işlev
  DateTime _getLastDayOfMonth(DateTime date) {
    return DateTime(date.year, date.month + 1, 0);
  }

  @override
  Widget build(BuildContext context) {
    return TableCalendar(
      locale: ('tr'),
      //bulunduğumuz gün için yukarıda değişkene DateTime.Now atadık.
      focusedDay: focusDayVarialable,
      // takvimin başlangıç ve bitiş tarihlerini belirledik
      firstDay: DateTime.utc(2000, 01, 01),
      lastDay: DateTime.utc(2050, 01, 01),
      //üst kısmı ay yıl isimlerini ortaladık, format değiştirmeyi kapattık
      headerStyle: HeaderStyle(
          titleTextStyle: FontStyles.instance.activityYazi,
          titleCentered: true,
          formatButtonVisible: false),
      calendarStyle: CalendarStyle(
          // ayda ki bütun hafta içi günlerin arkaplanını değiştirme sadece haftaiçi olan günlerin arkaplan rengi
          defaultDecoration: BoxDecoration(
              color: ColorsConstants.instance.baseThemeV2,
              shape: BoxShape.circle),
          todayDecoration: BoxDecoration(
              color: ColorsConstants.instance.baseTheme,
              shape: BoxShape.circle),
          selectedDecoration: BoxDecoration(
              color: ColorsConstants.instance.selectedDateCalendar,
              shape: BoxShape.circle)),
      onPageChanged: (focusedDay) {
        context.read<CalendarCubit>().filterChangeValue(1);
        context.read<CalendarCubit>().fetchMonthMeets(
            context.read<LoginCubit>().token,
            context.read<LoginCubit>().id,
            _getFirstDayOfMonth(focusedDay).toString().substring(0, 10),
            _getLastDayOfMonth(focusedDay).toString().substring(0, 10));
        // sayfa değiştirdikçe yukarıda ki fonksiyon sayesinde ayların ilk gününü ve son günlerini exp => (2023-10-01) / (2023-10-31) alıyoruz.
        //_getFirstDayOfMonth(focusedDay).toString().substring(0, 10).log();
        //_getLastDayOfMonth(focusedDay).toString().substring(0, 10).log();
      },
      onDaySelected: (selectedDay, focusedDay) {
        setState(() {
          selectedDayVarialable = selectedDay;
          focusDayVarialable = focusedDay;
          apiCallBackDate(context.read<CalendarCubit>(), selectedDay);
        });
      },
      selectedDayPredicate: (day) {
        return isSameDay(selectedDayVarialable, day);
      },
    );
  }

  void apiCallBackDate(CalendarCubit cubit, DateTime secilenTarih) {
    String gonderilecekTarih =
        secilenTarih.phpDateTimeConvertExtension(secilenTarih);
    cubit.filterMeetings(context.read<LoginCubit>().token,
        context.read<LoginCubit>().id, gonderilecekTarih,
        isWeek: false);
  }
}
