import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/features/calendar/model/update_meet_model.dart';

import '../../../core/cubits/dropdown_cubit.dart';
import '../../../core/utility/toast_manager.dart';
import '../../auth/login/cubit/login_cubit.dart';
import '../../customers/cubit/customers_cubit.dart';
import '../cubit/calendar_cubit.dart';
import '../view/calendar_detail_second_view.dart';
import '../widgets/multi_select_company_employee_dropdown.dart';
import '../widgets/multi_select_personal_dropdown.dart';

mixin CalendarDetailSecondViewMixin on State<CalendarDetailSecondView> {
  @override
  void initState() {
    debugPrint("calendar detail_second_view_mixin initState çalıştı");
    changeLoading();
    setInitialValues();
    context.read<DropdownCubit>().fetchYetkiliData(widget.projeFirmaId,
        context.read<LoginCubit>().token, context.read<LoginCubit>().id);
    changeLoading();
    super.initState();
  }

  void changeLoading() {
    setState(() {
      isLoading = !isLoading;
    });
  }

  @override
  void dispose() {
    super.dispose();
    if (context.mounted) {
      context.read<CalendarCubit>().selectedItemsMultiSelectReset();
    }
  }

  void setInitialValues() {
    seciliGorevlileriEkle();
    seciliSorumlulariEkle();
  }

  void seciliSorumlulariEkle() {
    gonderilecekFirmaYetkiliIdler = widget.pgonderilecekYetkiliIdler;
  }

  void seciliGorevlileriEkle() {
    gonderilecekPersonelIdler = widget.pgonderilecekUserIdler;
  }

  bool isLoading = true;

  String toplantiAdiKucult(String gelenToplanti) => gelenToplanti.length > 34
      ? '${gelenToplanti.substring(0, 33)}..'
      : gelenToplanti;

  ////////////////////////////////////////////////////////////////////////////

  List<String> secilenFirmaYetkiliList = [];
  String gonderilecekFirmaYetkiliIdler = '';

  void showMultiSelectCompanyEmployee() async {
    final List<String> items = [];

    final List<String>? results = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectCompanyEmployeeDropdown(items: items);
      },
    );

    if (results != null) {
      setState(() {
        secilenFirmaYetkiliList = results;
        // seçili gelen listenin id değerlerini virgüllerle veritabanı formatına uygun alıyoruz.
        List<int> yetkiliIdler = secilenFirmaYetkiliList
            .where((eleman) => int.tryParse(eleman) != null)
            .map((eleman) => int.parse(eleman))
            .toList();
        gonderilecekFirmaYetkiliIdler = yetkiliIdler.join(',');
      });
    }
  }

  ////////////////////////////////////////////////////////////////////////////

  List<String> secilenPersonelList = [];
  String gonderilecekPersonelIdler = '';

  void showMultiSelectPersonal() async {
    final List<String> items2 = [];

    final List<String>? results2 = await showDialog(
      context: context,
      builder: (BuildContext context) {
        return MultiSelectPersonalDropdown(items: items2);
      },
    );

    if (results2 != null) {
      setState(() {
        secilenPersonelList = results2;
        // seçili gelen listenin id değerlerini virgüllerle veritabanı formatına uygun alıyoruz.
        List<int> personelIdler = secilenPersonelList
            .where((eleman) => int.tryParse(eleman) != null)
            .map((eleman) => int.parse(eleman))
            .toList();
        gonderilecekPersonelIdler = personelIdler.join(',');
      });
    }
  }

  void mixinUpdateMeetMethod() {
    if (widget.tfBaslik.isNotEmpty &&
        widget.tfGundem.isNotEmpty &&
        widget.tfToplantiYeri.isNotEmpty &&
        widget.tfToplantiAciklama.isNotEmpty &&
        widget.alinanTarih.isNotEmpty &&
        widget.projeid.isNotEmpty &&
        widget.projeFirmaId.isNotEmpty &&
        widget.toplantiYoneticiId.isNotEmpty &&
        gonderilecekFirmaYetkiliIdler.isNotEmpty &&
        gonderilecekPersonelIdler.isNotEmpty) {
      String employeesID = ',$gonderilecekPersonelIdler,'.replaceAll(
          RegExp(',+'),
          ','); //fazladan art arda virgül var ise fazla virgülleri kaldırıyor..
      String leadersID =
          ',$gonderilecekFirmaYetkiliIdler,'.replaceAll(RegExp(',+'), ',');
      context
          .read<CalendarCubit>()
          .updateMeets(UpdateMeetModel(
              token: context.read<LoginCubit>().token,
              loginuserID: context.read<LoginCubit>().id,
              toplantiID: widget.toplantiID,
              toplantiProjeId: widget.projeid,
              toplantiYoneticiId: widget.toplantiYoneticiId,
              toplantiFirmaID: widget.projeFirmaId,
              toplantiYetkiliIdler: leadersID,
              toplantiUserIdler: employeesID,
              toplantiBaslik: widget.tfBaslik,
              toplantiGundem: widget.tfGundem,
              toplantiNot: widget.tfToplantiAciklama,
              toplantiTip: context.read<CustomersCubit>().secilenGorusmeTipi,
              toplantiTarihi: widget.alinanTarih,
              toplantiSure: widget.alinanSure,
              toplantiYeri: widget.tfToplantiYeri,
              toplantiTekrar:
                  context.read<CalendarCubit>().secilenToplantiTekrarTipi))
          .whenComplete(() async {
        ToastManager.instance.toastMessageService('Toplantı Güncellendi');
        await Future.delayed(const Duration(milliseconds: 1600), () {
          backToPage();
        });
      });
    } else {
      ToastManager.instance.toastMessageService('Eksik Alanlar Var !');
    }
  }

  void backToPage() {
    Navigator.popUntil(context, (route) => route.isFirst);
  }
}
