import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/cubits/dropdown_cubit.dart';
import '../view/add_meet_one_view.dart';

mixin AddMeetOneViewMixin on State<AddMeetOneView> {
  static final GlobalKey<FormState> addMeetKey = GlobalKey();
  late DropdownCubit cubit = DropdownCubit();
  /////////////////////////////////////////////////////////////////////////////

  final TextEditingController tfToplantiAd = TextEditingController();
  final TextEditingController tfToplantiGundem = TextEditingController();
  final TextEditingController tfToplantiSure = TextEditingController();
  final TextEditingController tfToplantiYeri = TextEditingController();
  final TextEditingController tfToplantiAciklama = TextEditingController();

  /////////////////////////////////////////////////////////////////////////////
  bool isLoading = true;
  bool saatSecildi = false;
  String dbSaat = '';
  String gosterilenSaat = '';

  void changeLoading() {
    setState(() {
      isLoading = !isLoading;
    });
  }

  @override
  void initState() {
    cubit = DropdownCubit();
    Future.microtask(() {
      Future.delayed(const Duration(milliseconds: 900))
          .whenComplete(() => changeLoading());
    });
    super.initState();
  }

  @override
  void dispose() {
    super.dispose();
    tfToplantiAd.dispose();
    tfToplantiGundem.dispose();
    tfToplantiSure.dispose();
    tfToplantiYeri.dispose();
    tfToplantiAciklama.dispose();
  }
}
