import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/calendar/constants/meet_constants.dart';
import 'package:hamlemuhcrm/features/calendar/tab_bar/customer_leaders_tab.dart';
import 'package:hamlemuhcrm/features/calendar/tab_bar/employee_tab.dart';
import 'package:hamlemuhcrm/features/calendar/view_mixin/calendar_detail_second_view_mixin.dart';

import '../../../core/constants/app_constants.dart';
import '../../../core/constants/font_styles.dart';
import '../../../core/cubits/dropdown_cubit.dart';
import '../tab_bar/custom_employee_tab_bar.dart';

class CalendarDetailSecondView extends StatefulWidget {
  final String toplantiAd;
  final String tfBaslik;
  final String tfGundem;
  final String tfToplantiYeri;
  final String tfToplantiAciklama;
  final String alinanSure;
  final String alinanTarih;
  final String toplantiID;
  final String toplantiYoneticiId;
  final String projeid;
  final String projeFirmaId;
  final String pgonderilecekUserIdler;
  final String pgonderilecekYetkiliIdler;
  final DropdownCubit cubit;

  const CalendarDetailSecondView({
    super.key,
    required this.toplantiAd,
    required this.tfBaslik,
    required this.tfGundem,
    required this.tfToplantiYeri,
    required this.tfToplantiAciklama,
    required this.alinanSure,
    required this.alinanTarih,
    required this.toplantiID,
    required this.toplantiYoneticiId,
    required this.projeid,
    required this.projeFirmaId,
    required this.pgonderilecekUserIdler,
    required this.pgonderilecekYetkiliIdler,
    required this.cubit,
  });

  @override
  State<CalendarDetailSecondView> createState() =>
      _CalendarDetailSecondViewState();
}

class _CalendarDetailSecondViewState extends State<CalendarDetailSecondView>
    with CalendarDetailSecondViewMixin, SingleTickerProviderStateMixin {
  late TabController tabController;

  @override
  void initState() {
    tabController = TabController(length: 2, vsync: this);
    tabController.addListener(() {});
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        elevation: 0,
        backgroundColor: Colors.transparent,
        iconTheme: const IconThemeData(color: Colors.black87),
        title: Text(toplantiAdiKucult(widget.toplantiAd),
            style: FontStyles.instance.appbarTitleStyle),
        centerTitle: true,
      ),
      body: Padding(
        padding: _pagePaddingAll,
        child: Column(
          children: [
            _pageImage,
            _heightSpaceEmpty,
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                _companyEmployeeSelectedWidget,
                _personalSelectedWidget,
              ],
            ),
            Expanded(
              child: Column(
                children: [
                  const SizedBox(height: 15),
                  Container(
                    margin: const EdgeInsets.symmetric(horizontal: 10),
                    decoration: BoxDecoration(
                        color: Colors.grey.shade200,
                        borderRadius: BorderRadius.circular(15)),
                    child: Column(
                      children: [
                        _tabBarContainer(context, tabController),
                      ],
                    ),
                  ),
                  SizedBox(
                    height: context.dynamicHeight(0.01),
                  ),
                  Expanded(
                    child: TabBarView(
                      controller: tabController,
                      children: const [
                        CustomLeadersListTabBar(),
                        EmployeeListTabBar(),
                      ],
                    ),
                  ),
                ],
              ),
            ),
            updateMeetButton,
          ],
        ),
      ),
    );
  }

  Widget get _pageImage => SizedBox(
        height: context.dynamicHeight(0.15),
        child: ImageEnums.meeting.toPageImage,
      );

  Widget _headLine(String title) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: [
        Text(
          '$title *',
          style: FontStyles.instance.employeetbxBaslik,
        ),
      ],
    );
  }

  Widget get _heightSpaceEmpty => SizedBox(
        height: context.dynamicHeight(0.025),
      );

  EdgeInsets get _pagePaddingAll =>
      EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.03));

  Widget _tabBarContainer(BuildContext context, TabController tabController) {
    return Container(
      padding: const EdgeInsets.all(6),
      height: context.dynamicHeight(0.0558),
      child: CustomEmloyeeTabBar(tabController: tabController),
    );
  }

  Widget get _headlineToContainerHeightSpace => SizedBox(
        height: context.dynamicHeight(0.01),
      );

  Widget get _companyEmployeeSelectedWidget =>
      Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
        _headLine(MeetConstants.instance.meetCompanyEmployeesTxt),
        _headlineToContainerHeightSpace,
        BlocBuilder<DropdownCubit, DropdownState>(
          builder: (context, state) {
            return Container(
                height: context.dynamicHeight(0.05),
                width: context.dynamicWidth(0.42),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: state.secilenYetkililer.isNotEmpty
                      ? Colors.grey.shade200
                      : Colors.white,
                  border: Border.all(
                    color: Colors.grey.withOpacity(0.6),
                  ),
                ),
                child: Row(children: [
                  SizedBox(width: context.dynamicWidth(0.04)),
                  Text(
                    state.secilenYetkililer.isNotEmpty ? 'Seçildi' : '',
                    style: const TextStyle(fontSize: 13.5),
                  ),
                  const Spacer(),
                  IconButton(
                    padding: EdgeInsets.zero,
                    onPressed: () {
                      showMultiSelectCompanyEmployee();
                    },
                    tooltip: 'Firma Yetkilisi Seç',
                    icon: Icon(
                      Icons.arrow_drop_down_sharp,
                      size: 23,
                      color: ColorsConstants.instance.baseTheme,
                    ),
                  )
                ]));
          },
        )
      ]);

  Widget get _personalSelectedWidget =>
      Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
        _headLine(MeetConstants.instance.meetEmployeesTxt),
        _headlineToContainerHeightSpace,
        BlocBuilder<DropdownCubit, DropdownState>(
          builder: (context, state) => Container(
              height: context.dynamicHeight(0.05),
              width: context.dynamicWidth(0.42),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                color: state.secilenCalisanlar.isNotEmpty
                    ? Colors.grey.shade200
                    : Colors.white,
                border: Border.all(
                  color: Colors.grey.withOpacity(0.6),
                ),
              ),
              child: Row(children: [
                SizedBox(width: context.dynamicWidth(0.04)),
                Text(
                  state.secilenCalisanlar.isNotEmpty ? 'Seçildi' : '',
                  style: const TextStyle(fontSize: 13.5),
                ),
                const Spacer(),
                IconButton(
                  padding: EdgeInsets.zero,
                  onPressed: () {
                    showMultiSelectPersonal();
                  },
                  tooltip: 'Personel Seç',
                  icon: Icon(
                    Icons.arrow_drop_down_sharp,
                    size: 23,
                    color: ColorsConstants.instance.baseTheme,
                  ),
                )
              ])),
        )
      ]);

  Widget get updateMeetButton => TextButton(
        onPressed: () {
          mixinUpdateMeetMethod();
        },
        style: TextButton.styleFrom(
          backgroundColor: ColorsConstants.instance.baseTheme,
        ),
        child: Center(
          child: Text(
            ApplicationConstants.instance.moduleSaveTxt,
            style: const TextStyle(color: Colors.white),
          ),
        ),
      );
}
