import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/color_constants.dart';
import 'package:hamlemuhcrm/core/extensions/image_enum_extension.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';
import 'package:hamlemuhcrm/features/calendar/constants/meet_constants.dart';
import 'package:hamlemuhcrm/features/calendar/tab_bar/custom_employee_tab_bar.dart';
import 'package:hamlemuhcrm/features/calendar/tab_bar/customer_leaders_tab.dart';
import 'package:hamlemuhcrm/features/calendar/tab_bar/employee_tab.dart';
import 'package:hamlemuhcrm/features/calendar/view_mixin/add_meet_second_view_mixin.dart';

import '../../../core/constants/app_constants.dart';
import '../../../core/constants/font_styles.dart';

class AddMeetSecondView extends StatefulWidget {
  final String tfBaslik;
  final String tfGundem;
  final String tfToplantiYeri;
  final String tfToplantiAciklama;
  final String toplantiYoneticiId;
  final String alinanSure;
  final String alinanTarih;
  final String projeid;
  final String projeFirmaId;

  const AddMeetSecondView({
    super.key,
    required this.tfBaslik,
    required this.tfGundem,
    required this.tfToplantiYeri,
    required this.tfToplantiAciklama,
    required this.toplantiYoneticiId,
    required this.alinanSure,
    required this.alinanTarih,
    required this.projeid,
    required this.projeFirmaId,
  });

  @override
  State<AddMeetSecondView> createState() => _AddMeetSecondViewState();
}

class _AddMeetSecondViewState extends State<AddMeetSecondView>
    with AddMeetSecondViewMixin, SingleTickerProviderStateMixin {
  late TabController tabController;

  @override
  void initState() {
    tabController = TabController(length: 2, vsync: this);
    tabController.addListener(() {});
    super.initState();
  }

  @override
  void dispose() {
    tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: _appBar(),
      body: Padding(
        padding: _pagePaddingAll,
        child: Column(
          children: [
            _pageImage,
            _heightSpaceEmpty,
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                _companyEmployeeSelectedWidget,
                _personalSelectedWidget,
              ],
            ),
            Expanded(
              child: Column(
                children: [
                  const SizedBox(height: 15),
                  Container(
                    margin: const EdgeInsets.symmetric(horizontal: 10),
                    decoration: BoxDecoration(
                        color: Colors.grey.shade200,
                        borderRadius: BorderRadius.circular(15)),
                    child: Column(
                      children: [
                        _tabBarContainer(context, tabController),
                      ],
                    ),
                  ),
                  SizedBox(
                    height: context.dynamicHeight(0.01),
                  ),
                  Expanded(
                    child: TabBarView(
                      controller: tabController,
                      children: const [
                        CustomLeadersListTabBar(),
                        EmployeeListTabBar(),
                      ],
                    ),
                  ),
                ],
              ),
            ),
            addMeetButton,
          ],
        ),
      ),
    );
  }

  AppBar _appBar() {
    return AppBar(
      elevation: 0,
      backgroundColor: Colors.transparent,
      iconTheme: const IconThemeData(color: Colors.black87),
      title: Text(MeetConstants.instance.addMeetPageSecondTxt,
          style: FontStyles.instance.appbarTitleStyle),
      centerTitle: true,
      actions: [
        IconButton(
            onPressed: () {}, icon: const Icon(Icons.notifications_none)),
      ],
    );
  }

  Widget get _pageImage => SizedBox(
        height: context.dynamicHeight(0.15),
        child: ImageEnums.meeting.toPageImage,
      );

  Widget _headLine(String title) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: [
        Text(
          '$title *',
          style: FontStyles.instance.employeetbxBaslik,
        ),
      ],
    );
  }

  Widget get _heightSpaceEmpty => SizedBox(
        height: context.dynamicHeight(0.025),
      );

  EdgeInsets get _pagePaddingAll =>
      EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.03));

  Widget _tabBarContainer(BuildContext context, TabController tabController) {
    return Container(
      padding: const EdgeInsets.all(6),
      height: context.dynamicHeight(0.0558),
      child: CustomEmloyeeTabBar(tabController: tabController),
    );
  }

  Widget get _headlineToContainerHeightSpace => SizedBox(
        height: context.dynamicHeight(0.01),
      );

  Widget get _companyEmployeeSelectedWidget =>
      Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
        _headLine(MeetConstants.instance.meetCompanyEmployeesTxt),
        _headlineToContainerHeightSpace,
        Container(
            height: context.dynamicHeight(0.05),
            width: context.dynamicWidth(0.42),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10),
              color: secilenFirmaYetkiliList.isNotEmpty
                  ? Colors.grey.shade200
                  : Colors.white,
              border: Border.all(
                color: Colors.grey.withOpacity(0.6),
              ),
            ),
            child: Row(children: [
              SizedBox(width: context.dynamicWidth(0.04)),
              Text(
                secilenFirmaYetkiliList.isNotEmpty ? 'Seçildi' : '',
                style: const TextStyle(fontSize: 13.5),
              ),
              const Spacer(),
              IconButton(
                padding: EdgeInsets.zero,
                onPressed: () {
                  showMultiSelectCompanyEmployee();
                },
                tooltip: 'Firma Yetkilisi Seç',
                icon: Icon(
                  Icons.arrow_drop_down_sharp,
                  size: 23,
                  color: ColorsConstants.instance.baseTheme,
                ),
              )
            ]))
      ]);

  Widget get _personalSelectedWidget =>
      Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
        _headLine(MeetConstants.instance.meetEmployeesTxt),
        _headlineToContainerHeightSpace,
        Container(
            height: context.dynamicHeight(0.05),
            width: context.dynamicWidth(0.42),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10),
              color: secilenPersonelList.isNotEmpty
                  ? Colors.grey.shade200
                  : Colors.white,
              border: Border.all(
                color: Colors.grey.withOpacity(0.6),
              ),
            ),
            child: Row(children: [
              SizedBox(width: context.dynamicWidth(0.04)),
              Text(
                secilenPersonelList.isNotEmpty ? 'Seçildi' : '',
                style: const TextStyle(fontSize: 13.5),
              ),
              const Spacer(),
              IconButton(
                padding: EdgeInsets.zero,
                onPressed: () {
                  showMultiSelectPersonal();
                },
                tooltip: 'Personel Seç',
                icon: Icon(
                  Icons.arrow_drop_down_sharp,
                  size: 23,
                  color: ColorsConstants.instance.baseTheme,
                ),
              )
            ]))
      ]);

  Widget get addMeetButton => TextButton(
        onPressed: () {
          mixinAddMeetMethod();
        },
        style: TextButton.styleFrom(
          backgroundColor: ColorsConstants.instance.baseTheme,
        ),
        child: Center(
          child: Text(
            ApplicationConstants.instance.moduleSaveTxt,
            style: const TextStyle(color: Colors.white),
          ),
        ),
      );
}
