import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../../core/cubits/dropdown_cubit.dart';
import 'widgets/profile_customers_leader_item.dart';

class CustomLeadersListTabBar extends StatefulWidget {
  const CustomLeadersListTabBar({super.key});

  @override
  State<CustomLeadersListTabBar> createState() =>
      _CustomLeadersListTabBarState();
}

class _CustomLeadersListTabBarState extends State<CustomLeadersListTabBar> {
  @override
  void initState() {
    super.initState();
    debugPrint("customer leaders tab bar initState çalıştı");
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<DropdownCubit, DropdownState>(
      builder: (context, state) {
        return BlocBuilder<DropdownCubit, DropdownState>(
            builder: (context, state) {
          switch (state.isComplete && !state.isLoading) {
            case true:
              return state.secilenYetkililer.isNotEmpty
                  ? ListView.builder(
                      itemCount: state.secilenYetkililer.length,
                      itemBuilder: (context, index) {
                        return ProfileCustomersLeaderCardItem(
                            model: state.secilenYetkililer[index]);
                      })
                  : _emptyListWidget;
            case false:
              return _emptyListWidget;
          }
        });
      },
    );
  }

  Widget get _emptyListWidget => Center(
        child: Text('Boş Liste',
            style: Theme.of(context)
                .textTheme
                .titleMedium
                ?.copyWith(color: Colors.grey)),
      );
}
