import 'package:flutter/material.dart';

import '../../../core/constants/color_constants.dart';
import '../constants/meet_constants.dart';

class CustomEmloyeeTabBar extends StatelessWidget {
  final TabController tabController;

  const CustomEmloyeeTabBar({super.key, required this.tabController});

  @override
  Widget build(BuildContext context) {
    return TabBar(
      unselectedLabelColor: Colors.grey.shade500,
      labelColor: ColorsConstants.instance.baseTheme,
      indicatorColor: Colors.white,
      indicatorSize: TabBarIndicatorSize.tab,
      dividerColor: Colors.transparent,
      indicator: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(10),
      ),
      controller: tabController,
      tabs: [
        Tab(
          text: MeetConstants.instance.meetCompanyEmployeesTxt,
        ),
        Tab(
          text: MeetConstants.instance.meetEmployeesTxt,
        ),
      ],
    );
  }
}
