part of 'suggestion_cubit.dart';

// Cubit durumunu temsil eden sınıf
class SuggestionState extends Equatable {
  final List<SuggestionModel> bekleyenGundemler;
  final List<SuggestionModel> onaylananGundemler;
  final String stateMessage;
  final bool isLoading;
  final bool isLoaded;
  final bool isCompleted;
  final bool isError;

  @override
  List<Object?> get props => [bekleyenGundemler,onaylananGundemler,stateMessage,isLoading, isLoaded, isError, isCompleted];

  const SuggestionState({
    required this.bekleyenGundemler,
    required this.onaylananGundemler,
    required this.stateMessage,
    required this.isLoading,
    required this.isLoaded,
    required this.isCompleted,
    required this.isError,
  });

  factory SuggestionState.initial() {
    return const SuggestionState(
        bekleyenGundemler: [],
        onaylananGundemler: [],
        stateMessage: '',
        isLoading: false,
        isLoaded: false,
        isError: false,
        isCompleted: false);
  }

  SuggestionState copyWith({
    List<SuggestionModel>? bekleyenGundemler,
    List<SuggestionModel>? onaylananGundemler,
    String? stateMessage,
    bool? isLoading,
    bool? isLoaded,
    bool? isError,
    bool? isCompleted,
  }) {
    return SuggestionState(
      bekleyenGundemler: bekleyenGundemler ?? this.bekleyenGundemler,
      onaylananGundemler: onaylananGundemler ?? this.onaylananGundemler,
      stateMessage: stateMessage ?? this.stateMessage,
      isLoading: isLoading ?? this.isLoading,
      isLoaded: isLoaded ?? this.isLoaded,
      isCompleted: isCompleted ?? this.isCompleted,
      isError: isError ?? this.isError,
    );
  }
}
