import 'package:equatable/equatable.dart';
import 'package:hamlemuhcrm/features/calendar/model/calendar_model.dart';

class CalendarState extends Equatable {
  final List<CalendarModel> toplantiList;
  final CalendarStatus status;
  final int filterIndex;
  final String secilenGun;
  final String secilenGunToplantiSayisi;
  final String errorMessage;

  const CalendarState({
    required this.toplantiList,
    required this.status,
    required this.filterIndex,
    required this.secilenGun,
    required this.secilenGunToplantiSayisi,
    required this.errorMessage,
  });

  factory CalendarState.initial() {
    return const CalendarState(
      toplantiList: [],
      status: CalendarStatus.initial,
      filterIndex: 0,
      secilenGun: '',
      secilenGunToplantiSayisi: '',
      errorMessage: '',
    );
  }

  CalendarState copyWith({
    List<CalendarModel>? toplantiList,
    CalendarStatus? status,
    int? filterIndex,
    String? secilenGun,
    String? secilenGunToplantiSayisi,
    String? errorMessage,
  }) {
    return CalendarState(
      toplantiList: toplantiList ?? this.toplantiList,
      status: status ?? this.status,
      filterIndex: filterIndex ?? this.filterIndex,
      secilenGun: secilenGun ?? this.secilenGun,
      secilenGunToplantiSayisi: secilenGunToplantiSayisi ?? this.secilenGun,
      errorMessage: errorMessage ?? this.errorMessage,
    );
  }

  @override
  List<Object?> get props => [
        toplantiList,
        status,
        filterIndex,
        secilenGun,
        secilenGunToplantiSayisi,
        errorMessage
      ];
}

enum CalendarStatus {
  initial,
  loading,
  loaded,
  error,
}
