import 'package:hamlemuhcrm/core/extensions/string_extension.dart';
import 'package:hamlemuhcrm/features/calendar/model/new_meet_model.dart';
import 'package:hamlemuhcrm/features/calendar/model/update_meet_model.dart';
import '../../../core/base/base_cubit.dart';
import '../../../data/repo/calendar_repository.dart';
import '../model/calendar_model.dart';
import 'calendar_state.dart';

final class CalendarCubit extends BaseCubit<CalendarState> {
  final CalendarRepository _repository;

  CalendarCubit(this._repository) : super(CalendarState.initial());

  List<String> secilenPersonelAdlar = [];
  List<String> secilenPersonelIdler = [];

  List<String> secilenFirmaYetkiliAdlar = [];
  List<String> secilenFirmaYetkiliIdler = [];

  String secilenProjeID = '';
  String secilenProjeFirmaID = '';
  String secilenToplantiYoneticiID = '';
  String secilenToplantiTekrarTipi = 'yok';

  List<CalendarModel> gelenHaftalikList = [];
  List<CalendarModel> toplantiList = [];

  // toplantilari haftalık olarak çekme, örnek selectedDate = (2023-03-03) gönderildiği zaman o haftada ki pazartesi-pazar arası bütün toplantılar gelir.

  Future<void> fetchMeets(String token, String loginuserid,
      {bool isWeek = false}) async {
    safeEmit(state.copyWith(
        status: CalendarStatus.loading,
        secilenGun: '',
        secilenGunToplantiSayisi: '',
        filterIndex: 2));
    try {
      gelenHaftalikList = await _repository
          .fetchMeets(token, loginuserid, ''.phpDateTimeNow, isWeek: isWeek);

      safeEmit(state.copyWith(
          status: CalendarStatus.loaded,
          toplantiList: gelenHaftalikList,
          filterIndex: isWeek ? 0 : 2));
    } catch (e) {
      safeEmit(state.copyWith(
          status: CalendarStatus.error,
          errorMessage: 'Veriler Yüklenirken Hata Oluştu'));
    }
  }

  Future<void> fetchMonthMeets(String token, String loginuserid,
      String monthFirstDate, String monthLastDate) async {
    safeEmit(state.copyWith(
        status: CalendarStatus.loading,
        secilenGun: '',
        secilenGunToplantiSayisi: '',
        filterIndex: 2));

    try {
      final list = await _repository.fetchMonthMeets(
          token, loginuserid, monthFirstDate, monthLastDate);
      await Future.delayed(const Duration(milliseconds: 1500)).then((value) =>
          safeEmit(state.copyWith(
              status: CalendarStatus.loaded,
              toplantiList: list,
              filterIndex: 1)));
    } catch (_) {
      safeEmit(state.copyWith(
          status: CalendarStatus.error,
          errorMessage: 'Sunucu Bağlantı Sorunu'));
    }
  }

  void selectedItemsMultiSelectReset() {
    secilenPersonelAdlar.clear();
    secilenPersonelIdler.clear();
    secilenProjeID = '';
    secilenProjeFirmaID = '';
    secilenToplantiTekrarTipi = 'yok';
    secilenFirmaYetkiliAdlar.clear();
    secilenFirmaYetkiliIdler.clear();
  }

  void filterChangeValue(int filterIndex) {
    // 0 : bu hafta, 1 : bu ay, diğerleri filtre yok seçilen gün
    safeEmit(state.copyWith(filterIndex: filterIndex));
  }

  Future<void> filterMeetings(
      String token, String loginuserid, String selectedDate,
      {bool isWeek = false}) async {
    safeEmit(state.copyWith(
        status: CalendarStatus.loading,
        secilenGun: '',
        secilenGunToplantiSayisi: '',
        filterIndex: 2));
    try {
      toplantiList = await _repository
          .fetchMeets(token, loginuserid, selectedDate, isWeek: isWeek);
      await Future.delayed(const Duration(milliseconds: 1100)).then((value) =>
          safeEmit(state.copyWith(
              status: CalendarStatus.loaded,
              toplantiList: toplantiList,
              secilenGun: selectedDate,
              filterIndex: isWeek ? 0 : 2)));
    } catch (e) {
      safeEmit(state.copyWith(
          status: CalendarStatus.error,
          errorMessage: 'Veriler yüklenirken hata oluştu !'));
    }
  }

  Future<void> viewUpdateMeet(
      String token, String loginuserid, String toplantiId) async {
    safeEmit(state.copyWith(
        status: CalendarStatus.loading, toplantiList: <CalendarModel>[]));
    await _repository.viewUpdateMeet(token, loginuserid, toplantiId);
    safeEmit(state.copyWith(
        status: CalendarStatus.loaded, toplantiList: toplantiList));
  }

  Future<void> addMeets(NewMeetModel addMeetModel) async {
    safeEmit(state.copyWith(
        status: CalendarStatus.loading,
        secilenGun: '',
        secilenGunToplantiSayisi: '',
        toplantiList: []));
    await _repository.addNewMeet(addMeetModel);
    // incelenecek.
    toplantiList = await _repository.fetchMeets(addMeetModel.token,
        addMeetModel.loginuserID, addMeetModel.toplantiTarihi.phpDateTimeNow);
    safeEmit(state.copyWith(
        secilenGun: '',
        secilenGunToplantiSayisi: '',
        toplantiList: toplantiList,
        status: CalendarStatus.loaded));
  }

  Future<void> updateMeets(UpdateMeetModel updateMeetModel) async {
    safeEmit(state.copyWith(status: CalendarStatus.loading));
    await _repository.updateMeets(updateMeetModel);
    // incelenecek..
    toplantiList = await _repository.fetchMeets(
        updateMeetModel.token,
        updateMeetModel.loginuserID,
        updateMeetModel.toplantiTarihi.phpDateTimeNow);
    safeEmit(state.copyWith(
        secilenGun: '',
        secilenGunToplantiSayisi: '',
        toplantiList: toplantiList,
        status: CalendarStatus.loaded));
  }
}
