import 'package:flutter/material.dart';

import '../../../../core/constants/color_constants.dart';
import '../../../../core/extensions/responsive_extension.dart';
import 'login_constants.dart';

class MailTextFieldInput extends InputDecoration {
  MailTextFieldInput(BuildContext context)
      : super(
            prefixIcon: Icon(
              size: 24,
              Icons.local_post_office_outlined,
              color: ColorsConstants.instance.baseTheme.withOpacity(0.8),
            ),
            hintText: LoginConstants.loginEmailText,
            hintStyle: const TextStyle(color: Colors.black54, fontSize: 14),
            contentPadding:
                EdgeInsets.symmetric(horizontal: context.dynamicWidth(0.05)),
            border: const OutlineInputBorder(
              borderSide: BorderSide.none,
            ));
}
