import 'dart:convert';
import 'dart:io';

import 'package:dio/dio.dart';
import 'package:hamlemuhcrm/core/base/base_response.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/init/network/network_manager.dart';
import 'package:hamlemuhcrm/features/profile/model/profile_detail.dart';

class UserRepository {
  Dio dio = NetworkManager.instance.dio;

  Future<BaseResponseModel?> updateProfileChange(ProfileDetail model) async {
    try {
      var url = URLAPIService.instance.profilGuncelleURL;
      final response =
          await dio.post(url, data: FormData.fromMap(model.toJson()));

      if (response.statusCode == HttpStatus.ok) {
        if (response.data is Map<String, dynamic>) {
          return BaseResponseModel.fromJson(response.data);
        } else if (response.data is String) {
          final Map<String, dynamic> responseData = jsonDecode(response.data);
          return BaseResponseModel.fromJson(responseData);
        }
        return null;
      } else {
        'result data : ${response.data}'.log();
        'result status code : ${response.statusCode}'.log();
        'result type: ${response.data.runtimeType}'.log();
        return null;
      }
    } catch (error) {
      throw Exception('Hata : updateProfileChange $error');
    }
  }
}
