import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/core/init/network/network_manager.dart';
import 'package:hamlemuhcrm/features/projects/model/asamalar.dart';
import 'package:hamlemuhcrm/features/projects/model/asamalar_cevap.dart';
import 'package:hamlemuhcrm/features/projects/model/gorevler.dart';
import 'package:hamlemuhcrm/features/projects/model/gorevler_cevap.dart';
import 'package:hamlemuhcrm/features/projects/model/mission_employee_note.dart';
import 'package:hamlemuhcrm/features/projects/model/mission_employee_note_response.dart';
import 'package:hamlemuhcrm/features/projects/model/projeler.dart';
import 'package:hamlemuhcrm/features/projects/model/projeler_cevap.dart';
import 'package:hamlemuhcrm/features/projects/view/missions_partial/model/mission_update_model.dart';
import 'package:hamlemuhcrm/features/projects/view/missions_partial/model/task_add_model.dart';

import '../../features/projects/model/mission_employee_note_add_model.dart';

class ProjectRepository {
  final Dio dio = NetworkManager.instance.dio;

  //BÜTÜN METOTLAR GÜNCELLENDİ token,loginuserid eklendi.....

  List<Projeler>? parseProjeler(String cevap) {
    /*Parse*/
    return ProjelerCevap.fromJson(json.decode(cevap)).projeler;
  }

  Future<List<Projeler>?> kisiprojeleriListele(String loginuserid, String token,
      String userfirmid, String userType) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeListeleURL;
    var veri = {
      "loginuserid": loginuserid,
      "token": token,
      "userfirmid": userfirmid,
      "usertip": userType
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    //print(cevap.data.toString());
    return parseProjeler(cevap.data.toString());
  }

  Future<List<Projeler>?> kisiArsivprojeleriListele(String loginuserid,
      String token, String userfirmid, String userType) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeArsivListeleURL;
    var veri = {
      "loginuserid": loginuserid,
      "token": token,
      "userfirmid": userfirmid,
      "usertip": userType
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    //print(cevap.data.toString());
    return parseProjeler(cevap.data.toString());
  }

  Future<void> projeArsivleArsivdenCikar(String projeId, String projeOnay,
      String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeArsivleArsivdenCikarURL;
    var veri = {
      "proje_id": projeId,
      "proje_onay": projeOnay,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'proje arsivlendi / cikarildi : ${cevap.data.toString()}'.log();
  }

  Future<void> projEkle(
      String
          loginuserid, //proje_veren_user_id ye karşılık olarak loginuserid gönderilir..
      String projeUserfirmId,
      String projeFirmaId,
      String projeAd,
      String projeAciklama,
      String projeBaslangicTarihi,
      String projeBitisTarihi,
      String projeSorumlular,
      String projeGorevliler,
      String token) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeEkleURL;
    var veri = {
      "loginuserid": loginuserid,
      "proje_userfirm_id": projeUserfirmId,
      "proje_firma_id": projeFirmaId,
      "proje_ad": projeAd,
      "proje_aciklama": projeAciklama,
      "proje_baslangic_tarihi": projeBaslangicTarihi,
      "proje_bitis_tarihi": projeBitisTarihi,
      "proje_sorumlular": projeSorumlular,
      "proje_gorevliler": projeGorevliler,
      "token": token,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'proje ekle : ${cevap.data.toString()}'.log();
  }

  Future<void> projeGuncelle(
      String projeId,
      String projeFirmaId,
      String projeAd,
      String projeAciklama,
      String projeBaslangicTarihi,
      String projeBitisTarihi,
      String projeSorumlular,
      String projeGorevliler,
      String token,
      String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeGuncelleURL;
    var veri = {
      "proje_id": projeId,
      "proje_firma_id": projeFirmaId,
      "proje_ad": projeAd,
      "proje_aciklama": projeAciklama,
      "proje_baslangic_tarihi": projeBaslangicTarihi,
      "proje_bitis_tarihi": projeBitisTarihi,
      "proje_sorumlular": projeSorumlular,
      "proje_gorevliler": projeGorevliler,
      "token": token,
      "loginuserid": loginuserid,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'proje guncelle : ${cevap.data.toString()}'.log();
  }

////////////////// ASAMALAR //////////////

  List<Asamalar>? parseAsamalar(String cevap) {
    /* Parse*/
    return AsamalarCevap.fromJson(json.decode(cevap)).asamalar;
  }

  Future<List<Asamalar>?> projeAsamalariListele(
      String asamaProjeId, String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeAsamaListeleURL;
    var veri = {
      "asama_proje_id": asamaProjeId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    //print(cevap.data.toString());
    return parseAsamalar(cevap.data.toString());
  }

  Future<void> asamaEkle(
    String asamaProjeId,
    String asamaUserfirmId,
    String asamaAd,
    String olusturanaBildirim,
    String sorumluyaBildirim,
    String calisanaBildirim,
    String asamaArsiv,
    String token,
    String loginuserid,
  ) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeAsamaEkleURL;
    var veri = {
      "asama_proje_id": asamaProjeId,
      "asama_userfirm_id": asamaUserfirmId,
      "asama_ad": asamaAd,
      "olusturana_bildirim": olusturanaBildirim,
      "sorumluya_bildirim": sorumluyaBildirim,
      "calisana_bildirim": calisanaBildirim,
      "asama_arsiv": asamaArsiv,
      "token": token,
      "loginuserid": loginuserid,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    debugPrint('asama ekle : ${cevap.data.toString()}');
  }

  Future<void> asamaGuncelle(
      String asamaId,
      String asamaAd,
      String olusturanaBildirim,
      String sorumluyaBildirim,
      String calisanaBildirim,
      String asamaArsiv,
      String token,
      String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeAsamaGuncelleURL;
    var veri = {
      "asama_id": asamaId,
      "asama_ad": asamaAd,
      "olusturana_bildirim": olusturanaBildirim,
      "sorumluya_bildirim": sorumluyaBildirim,
      "calisana_bildirim": calisanaBildirim,
      "asama_arsiv": asamaArsiv,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    debugPrint('asama guncelle : ${cevap.data.toString()}');
  }

  ////////////////// GOREVLER //////////////

  List<Gorevler>? parseGorevler(String cevap) {
    /*Parse*/
    return GorevlerCevap.fromJson(json.decode(cevap)).gorevler;
  }

  Future<List<Gorevler>?> projeGorevListele(String gorevProjeId, String token,
      String loginuserid, String userfirmid, String userType) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeGorevListeleURL;
    var veri = {
      "gorev_proje_id": gorevProjeId,
      "token": token,
      "loginuserid": loginuserid,
      "userfirmid": userfirmid,
      "usertip": userType,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    return parseGorevler(cevap.data.toString());
  }

  Future<void> anaGorevEkle(
      String loginuserid,
      String token,
      String kayitliFirma,
      String gorevliler,
      String sorumlular,
      String projeId,
      String gorevAd,
      String gorevAciklama,
      String gorevBaslangicT,
      String gorevBitisT,
      String renkEtiketi,
      String gorevDurum) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeAnaGorevEkleURL;
    var veri = {
      "loginuserid": loginuserid,
      "token": token,
      "gorev_userfirm_id": kayitliFirma,
      "gorevliler": gorevliler,
      "gorevsorumlular": sorumlular,
      "gorev_proje_id": projeId,
      "gorev_ad": gorevAd,
      "gorev_aciklama": gorevAciklama,
      "gorev_baslangic_tarihi": gorevBaslangicT,
      "gorev_bitis_tarihi": gorevBitisT,
      "renketiketi": renkEtiketi,
      "gorev_durum": gorevDurum //asamanın ıdsi
    };
    await dio.post(url, data: FormData.fromMap(veri));
  }

  Future<void> anaGorevGuncelle(MissionUpdateModel addMission) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.projeAnaGorevGuncelleURL;
    final response =
        await dio.post(url, data: FormData.fromMap(addMission.toJson()));
    debugPrint(response.data);
  }

  List<MissionEmployeeNote>? parseNotlar(String cevap) {
    /* Parse*/
    return MissionEmployeeNoteResponse.fromJson(json.decode(cevap))
        .calisanKayit;
  }

  Future<List<MissionEmployeeNote>?> gorevCalisanNotlariListele(
      String isGorevId, String token, String loginuserid) async {
    var url = URLAPIService.instance.projeAnaGorevCalisanNotlariListeleURL;
    var veri = {
      "is_gorev_id": isGorevId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    debugPrint('cevap : ${cevap.data}');
    return parseNotlar(cevap.data.toString());
  }

  Future<void> ekGorevOnayla(String gorevId, String gorevDurum, String token,
      String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.ekGorevOnaylaURL;
    var veri = {
      "gorev_id": gorevId,
      "gorev_durum": gorevDurum,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    debugPrint('ekGorev : ${cevap.data.toString()}');
  }

  Future<void> ekGorevEkle(AddTaskModel model) async {
    var url = URLAPIService.instance.ekGorevEkleURL;
    var cevap = await dio.post(url, data: FormData.fromMap(model.toJson()));
    debugPrint(cevap.data.toString());
  }

  Future<List<Gorevler>>? fetchAllMission(
      String token, String loginuserid) async {
    try {
      var url = URLAPIService.instance.projeTumGorevleriListeleURL;
      var veri = {"loginuserid": loginuserid, "token": token};
      final response = await dio.post(url, data: FormData.fromMap(veri));
      if (response.statusCode == 200) {
        //'basarılı gibi ${response.data}'.log();
        return GorevlerCevap.fromJson(json.decode(response.data)).gorevler ??
            [];
      }
    } catch (e) {
      'tum gorevler de hata'.log();
      return [];
    }
    return [];
  }

  Future<List<Gorevler>>? fetchMissionTask(
      String token, String loginuserid, String gorevUstId) async {
    try {
      var url = URLAPIService.instance.projeGorevinEkGorevleriListeleURL;
      var veri = {
        "token": token,
        "loginuserid": loginuserid,
        "gorev_ust_id": gorevUstId
      };
      final response = await dio.post(url, data: FormData.fromMap(veri));
      if (response.statusCode == 200) {
        //'basarılı gibi ${response.data}'.log();
        return GorevlerCevap.fromJson(json.decode(response.data)).gorevler ??
            [];
      }
    } catch (e) {
      'tum gorevler de hata'.log();
      return [];
    }
    return [];
  }

  Future<Response> fetchAllStage(
      String asamaProjeId, String token, String loginuserid) async {
    var url = URLAPIService.instance.asamalarDDCekURL;
    var veri = {
      "asama_proje_id": asamaProjeId,
      "token": token,
      "loginuserid": loginuserid
    };
    var response = await dio.post(url, data: FormData.fromMap(veri));
    return response;
  }

  Future<Response> fetchAllProjects(
      String userfirmId, String token, String loginuserid) async {
    var url = URLAPIService.instance.projeListeleDDURL;
    var veri = {
      "userfirmid": userfirmId,
      "token": token,
      "loginuserid": loginuserid
    };
    var response = await dio.post(url, data: FormData.fromMap(veri));
    return response;
  }

  Future<void> addNewMissionNote(MissionAddNoteModel model) async {
    var url = URLAPIService.instance.projeAnaGorevCalisanNotEkleURL;
    var cevap = await dio.post(url, data: FormData.fromMap(model.toJson()));
    debugPrint(cevap.data.toString());
  }
}
