import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/features/notification/model/notification_response.dart';

import '../../core/base/base_response.dart';
import '../../core/constants/url_services_constant.dart';
import '../../core/init/network/network_manager.dart';

class NotificationRepository {
  final Dio dio = NetworkManager.instance.dio;

  Future<BaseResponseModel?> fcmTokenAddOrUpdate(String loginuserid,
      String userfirmid, String fcmtoken, String token) async {
    try {
      var url = URLAPIService.instance.fcmTokenEkleGuncelleURL;
      var veri = {
        'token': token,
        'fcmtoken': fcmtoken,
        'user_firm_id': userfirmid,
        'loginuserid': loginuserid
      };
      var response = await dio.post(url, data: FormData.fromMap(veri));
      if (response.statusCode == 200) {
        final Map<String, dynamic> responseMap = response.data is String
            ? json.decode(response.data)
            : response.data;
        return BaseResponseModel.fromJson(responseMap);
      } else {
        return BaseResponseModel(message: 'İşlem başarısız', success: 0);
      }
    } catch (e) {
      'Hata yakalandı: $e'.log();
      return BaseResponseModel(message: 'Hata Oluştu', success: 0);
    }
  }

  Future<NotificationResponse?> fetchNotifications(
      String loginuserid, String bildirimUserFirmId, String token) async {
    try {
      var url = URLAPIService.instance.bildirimListeleURL;
      var veri = {
        'token': token,
        'loginuserid': loginuserid,
        'bildirim_userfirm_id': bildirimUserFirmId
      };
      var response = await dio.post(url, data: FormData.fromMap(veri));
      //'bildirimler: ${response.data}'.log();
      if (response.statusCode == 200) {
        final Map<String, dynamic> responseMap = response.data is String
            ? json.decode(response.data)
            : response.data;
        return NotificationResponse.fromJson(responseMap);
      } else {
        return NotificationResponse(message: 'İşlem başarısız', success: 0);
      }
    } catch (e) {
      debugPrint('Hata yakalandı: $e');
      return NotificationResponse(message: 'Hata Oluştu', success: 0);
    }
  }

  Future<BaseResponseModel?> readNotification(
      String token, String loginuserid, String bildirimId) async {
    try {
      var url = URLAPIService.instance.bildirimGoruntuleURL;
      var veri = {
        'token': token,
        'bildirim_id': bildirimId,
        'loginuserid': loginuserid
      };
      var response = await dio.post(url, data: FormData.fromMap(veri));
      if (response.statusCode == 200) {
        final Map<String, dynamic> responseMap = response.data is String
            ? json.decode(response.data)
            : response.data;
        return BaseResponseModel.fromJson(responseMap);
      } else {
        return BaseResponseModel(message: 'İşlem başarısız', success: 0);
      }
    } catch (e) {
      'Hata yakalandı: $e'.log();
      return BaseResponseModel(message: 'Hata Oluştu', success: 0);
    }
  }
}
