import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:hamlemuhcrm/core/constants/url_services_constant.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';
import 'package:hamlemuhcrm/features/human_resources/model/personel.dart';
import 'package:hamlemuhcrm/features/human_resources/model/personel_cevap.dart';

class EmployeeRepository {
  final Dio dio = Dio();

  //BÜTÜN METOTLAR GÜNCELLENDİ token,loginuserid eklendi.....

  List<Personel> parsePersonelCevap(String cevap) {
    /*Parse*/
    return PersonelCevap.fromJson(json.decode(cevap)).personel;
  }

  Future<List<Personel>>? personelListesi(
      String userUserfirmId, String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    //usertip göndermezse sadece o firmaya ait personeller gelir 33 gönderirse bütün firmalardaki personeller gelir
    var url = URLAPIService.instance.personellerURL;
    var veri = {
      "user_userfirm_id": userUserfirmId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    //print('personeller : ${cevap.data.toString()}');
    return parsePersonelCevap(cevap.data.toString());
  }

  Future<List<Personel>>? personelArsivListesi(
      String userUserfirmId, String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    //usertip göndermezse sadece o firmaya ait arşivlenmiş personeller gelir 33 gönderirse bütün firmalardaki arşiv personeller gelir
    var url = URLAPIService.instance.personellerArsivURL;
    var veri = {
      "user_userfirm_id": userUserfirmId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    return parsePersonelCevap(cevap.data.toString());
  }

  Future<void> personelEkle(
    String userUserfirmId,
    String firstName,
    String lastName,
    String email,
    String password,
    String ceptelefon,
    String userDataAdres,
    String userdataIseGirisTarihi,
    String userdataTcKimlik,
    String userdataAskerlikDurumu,
    String unvanId,
    String token,
    String loginuserid,
    String loginusertype,
  ) async {
    /*guncel token,loginid ekli - larawellden gelen api*/
    var url = URLAPIService.instance.personelEkleURL;
    var veri = {
      "user_userfirm_id": userUserfirmId,
      "first_name": firstName,
      "last_name": lastName,
      "email": email,
      "password": password,
      "ceptelefon": ceptelefon,
      "userdata_adres": userDataAdres,
      "userdata_ise_giris_tarihi": userdataIseGirisTarihi,
      "userdata_tc_kimlik": userdataTcKimlik,
      "userdata_askerlik_durumu": userdataAskerlikDurumu,
      "unvan_id": unvanId,
      "token": token,
      "loginuserid": loginuserid,
      "loginusertype": loginusertype
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'personel ekle : ${cevap.data.toString()}'.log();
  }

  Future<void> personelGuncelle(
    String guncellenecekID,
    String userUserfirmId,
    String firstName,
    String lastName,
    String email,
    String password,
    String ceptelefon,
    String userDataAdres,
    String userDataIseGirisTarihi,
    String userdataTcKimlik,
    String userdataAskerlikDurumu,
    String unvanId,
    String token,
    String loginuserid,
    String loginusertype,
  ) async {
    var url = URLAPIService.instance.personelGuncelleURL;
    var veri = {
      "id": guncellenecekID,
      "user_userfirm_id": userUserfirmId,
      "first_name": firstName,
      "last_name": lastName,
      "email": email,
      "password": password,
      "ceptelefon": ceptelefon,
      "userdata_adres": userDataAdres,
      "userdata_ise_giris_tarihi": userDataIseGirisTarihi,
      "userdata_tc_kimlik": userdataTcKimlik,
      "userdata_askerlik_durumu": userdataAskerlikDurumu,
      "unvan_id": unvanId,
      "token": token,
      "loginuserid": loginuserid,
      "loginusertype": loginusertype
    };
    /*guncel token,loginid ekli - laravelden gelen api*/
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'personel guncelle : ${cevap.data.toString()}'.log();
  }

  Future<void> personelArsivle(
      String arsivlenecekUserId, String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.personelArsivleURL;
    var veri = {
      "arsivlenecek_user_id": arsivlenecekUserId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    "Personel Arşivle : ${cevap.data.toString()}".log();
  }

  Future<void> personelArsivdenCikar(String arsivdenCikarilacakUserId,
      String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.personelArsivdenCikarURL;
    var veri = {
      "arsivden_cikarilacak_user_id": arsivdenCikarilacakUserId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    "Personel Arşivden Çıkar : ${cevap.data.toString()}".log();
  }
}
