import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';

import '../../core/constants/url_services_constant.dart';
import '../../features/customers/model/firma_yetkililer.dart';
import '../../features/customers/model/firma_yetkililer_cevap.dart';

class CompanyPersonalRepository {
  final Dio dio = Dio();

  //BÜTÜN METOTLAR GÜNCELLENDİ token,loginuserid eklendi.....

  List<FirmaYetkililer>? parseFirmaYetkililer(String cevap) {
    /*Parse*/
    return FirmaYetkililerCevap.fromJson(json.decode(cevap)).firmaYetkililer;
  }

  Future<List<FirmaYetkililer>?> yetkiliListele(
      String yetkiliFirmaId, String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.yetkiliListeleURL;
    var veri = {
      "yetkili_firma_id": yetkiliFirmaId,
      "token": token,
      "loginuserid": loginuserid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    '${cevap.data}'.log();
    return parseFirmaYetkililer(cevap.data.toString());
  }

  Future<void> yetkiliEkle(
      String yetkiliFirmaId,
      String yetkiliUserfirmId,
      String yetkiliAdSoyad,
      String yetkiliIlgiliBirim,
      String yetkiliGsm,
      String yetkiliMail,
      String yetkiliNot,
      String loginuserid,
      String token) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.yetkiliEkleURL;
    var veri = {
      "yetkili_firma_id": yetkiliFirmaId,
      "yetkili_userfirm_id": yetkiliUserfirmId,
      "yetkili_adsoyad": yetkiliAdSoyad,
      "yetkili_ilgilibirim": yetkiliIlgiliBirim,
      "yetkili_gsm": yetkiliGsm,
      "yetkili_mail": yetkiliMail,
      "yetkili_not": yetkiliNot,
      "loginuserid": loginuserid,
      "token": token,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'Müşteri Yetkili Ekle : ${cevap.data}'.log();
  }

  Future<void> yetkiliSil(
      String yetkiliId, String loginuserid, String token) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.yetkiliSilURL;
    var veri = {
      "yetkili_id": yetkiliId,
      "loginuserid": loginuserid,
      "token": token
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    '${cevap.data}'.log();
  }

  Future<void> yetkiliGuncelle(
      String yetkiliId,
      String yetkiliAdSoyad,
      String yetkiliIlgiliBirim,
      String yetkiliGsm,
      String yetkiliMail,
      String yetkiliNot,
      String loginuserid,
      String token) async {
    var url = URLAPIService.instance.yetkiliGuncelleURL;
    var veri = {
      "yetkili_id": yetkiliId,
      "yetkili_adsoyad": yetkiliAdSoyad,
      "yetkili_ilgilibirim": yetkiliIlgiliBirim,
      "yetkili_gsm": yetkiliGsm,
      "yetkili_mail": yetkiliMail,
      "yetkili_not": yetkiliNot,
      "loginuserid": loginuserid,
      "token": token,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    '${cevap.data}'.log();
  }

  Future<String> yetkilikontrolEt(String token, String loginuserid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.aktiviteKontrolEt;
    var veri = {"token": token, "loginuserid": loginuserid};
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    return cevap.data.toString();
  }
}
