import 'dart:async';
import 'dart:convert';

import 'package:dio/dio.dart';
import 'package:hamlemuhcrm/core/extensions/log_extension.dart';

import '../../core/base/base_response.dart';
import '../../core/constants/url_services_constant.dart';
import '../../core/init/network/network_manager.dart';
import '../../features/customers/model/aktiviteler.dart';
import '../../features/customers/model/aktiviteler_cevap.dart';
import '../../features/customers/model/new_activity.dart';

class ActivitiesRepository {
  final Dio dio = NetworkManager.instance.dio;

  //BÜTÜN METOTLAR GÜNCELLENDİ token,loginuserid eklendi.....

  Future<List<Aktiviteler>?> kisiAktiviteleriListele(
      String loginuserid, String token, String tip, String userfirmid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.kisiAktiviteListeleURL;
    var veri = {
      "loginuserid": loginuserid,
      "token": token,
      "usertip": tip,
      "userfirmid": userfirmid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    //'aktiviteler : ${cevap.data}'.log();
    return parseAktiviteler(cevap.data.toString());
  }

  Future<List<Aktiviteler>?> kisiArsivAktiviteListele(
      String loginuserid, String token, String tip, String userfirmid) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.kisiArsivAktiviteListeleURL;
    var veri = {
      "loginuserid": loginuserid,
      "token": token,
      "usertip": tip,
      "userfirmid": userfirmid
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    return parseAktiviteler(cevap.data.toString());
  }

  Future<List<Aktiviteler>?> firmaAktiviteleriListele(
      String gorusmeFirmaId,
      String token,
      String loginuserid,
      String userfirmid,
      String usertip) async {
    /*guncel token,loginid eklendi => firma_aktiviteler_pdo*/
    var url = URLAPIService.instance.firmaAktiviteListeleURL;
    var veri = {
      "gorusme_firma_id": gorusmeFirmaId,
      "token": token,
      "loginuserid": loginuserid,
      "userfirmid": userfirmid,
      "usertip": usertip,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    return parseAktiviteler(cevap.data.toString());
  }

  Future<List<Aktiviteler>?> firmaArsivAktiviteleriListele(
      String gorusmeFirmaId,
      String token,
      String loginuserid,
      String userfirmid,
      String usertip) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.firmaArsivAktiviteListeleURL;
    var veri = {
      "gorusme_firma_id": gorusmeFirmaId,
      "token": token,
      "loginuserid": loginuserid,
      "userfirmid": userfirmid,
      "usertip": usertip,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    return parseAktiviteler(cevap.data.toString());
  }

  Future<BaseResponseModel?> aktiviteEkle(NewActivityModel model) async {
    try {
      var url = URLAPIService.instance.aktiviteEkleURL;
      var cevap = await dio.post(url, data: FormData.fromMap(model.toJson()));
      if (cevap.statusCode == 200) {
        final Map<String, dynamic> responseMap =
            cevap.data is String ? json.decode(cevap.data) : cevap.data;
        return BaseResponseModel.fromJson(responseMap);
      } else {
        return BaseResponseModel(message: 'İşlem başarısız', success: 0);
      }
    } catch (e) {
      'Hata yakalandı: $e'.log();
      return BaseResponseModel(message: 'Hata Oluştu', success: 0);
    }
  }

  Future<void> aktiviteArsivle(
      String gorusmeId, String loginuserid, String token) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.aktiviteArsivleURL;
    var veri = {
      "gorusme_id": gorusmeId,
      "loginuserid": loginuserid,
      "token": token
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    "Aktivite Arşivle : ${cevap.data.toString()}".log();
  }

  Future<void> aktiviteArsivdenCikar(
      String gorusmeId, String loginuserid, String token) async {
    /*guncel token,loginid eklendi*/
    var url = URLAPIService.instance.aktiviteArsivdenCikarURL;
    var veri = {
      "gorusme_id": gorusmeId,
      "loginuserid": loginuserid,
      "token": token
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    "Aktivite Arşivden Çıkar : ${cevap.data.toString()}".log();
  }

  Future<List<Aktiviteler>?> tarihegoreAktiviteleriListele(
    String baslangicTarih,
    String bitisTarihi,
    String userUserFirmId,
    String loginuserid,
    String userTip,
    String token,
  ) async {
    /*guncel token,loginid eklendi*/
    //gönderilen user tip e göre eğer 0 ise sadece kendi eklediği aktiviteleri 1
    //veya 33 ise kendi userfirmindeki gönderdiği tarih aralığına göre tüm aktiviteleri görebilir.
    var url = URLAPIService.instance.tarihegoreAktivitelerURL;
    var veri = {
      "baslangic": baslangicTarih,
      "bitis": bitisTarihi,
      "user_userfirm_id": userUserFirmId,
      "loginuserid": loginuserid,
      "usertip": userTip,
      "token": token,
    };
    var cevap = await dio.post(url, data: FormData.fromMap(veri));
    'tarihe gore aktiviteler : ${cevap.data.toString()}'.log();
    return parseAktiviteler(cevap.data.toString());
  }

  // Future<List<Aktiviteler>?> AktiviteAra(
  //     String arama_kelimesi, String tip, String user_id) async {
  //   var url = URLService.tumAktiviteleriAraURL;
  //   var veri = {
  //     "gorusme_baslik": arama_kelimesi,
  //     "user_tip": tip,
  //     "firma_ekleyen_user_id": user_id,
  //   };

  //   var cevap = await dio.post(url, data: FormData.fromMap(veri));
  //   cevap.data.log();
  //   return parseAktiviteler(cevap.data.toString());
  // }

  Future<BaseResponseModel?> aktiviteGuncelle(
      String gorusmeId,
      String gorusmeBaslik,
      String gorusmeYetkiliId,
      String gorusmeUserIdler,
      String gorusmeTarihi,
      String gorusmeTip,
      String gorusmeNot,
      String loginuserid,
      String token) async {
    /*guncel token,loginid eklendi*/

    try {
      var url = URLAPIService.instance.aktiviteGuncelleURL;
      var veri = {
        "gorusme_id": gorusmeId,
        "gorusme_baslik": gorusmeBaslik,
        "gorusme_yetkili_id": gorusmeYetkiliId,
        "gorusme_user_idler": gorusmeUserIdler,
        "gorusme_tarihi": gorusmeTarihi,
        "gorusme_tip": gorusmeTip,
        "gorusme_not": gorusmeNot,
        "loginuserid": loginuserid,
        "token": token
      };
      final response = await dio.post(url, data: FormData.fromMap(veri));

      if (response.statusCode == 200) {
        final Map<String, dynamic> responseMap = response.data is String
            ? json.decode(response.data)
            : response.data;
        return BaseResponseModel.fromJson(responseMap);
      } else {
        return BaseResponseModel(message: 'İşlem başarısız', success: 0);
      }
    } catch (e) {
      'Hata yakalandı: $e'.log();
      return BaseResponseModel(message: 'Hata Oluştu', success: 0);
    }
  }
}

List<Aktiviteler>? parseAktiviteler(String cevap) {
  /*Parse*/
  return AktivitelerCevap.fromJson(json.decode(cevap)).aktiviteler;
}
