class YetkiliDDModel {
  String yetkiliId;
  String yetkiliAdSoyad;
  String? yetkiliIlgiliBirim;
  YetkiliDDModel(
      {required this.yetkiliId,
      required this.yetkiliAdSoyad,
      required this.yetkiliIlgiliBirim});
  factory YetkiliDDModel.fromJSON(Map<String, dynamic> datarow) {
    return YetkiliDDModel(
        yetkiliId: datarow['yetkili_id'],
        yetkiliAdSoyad: datarow['yetkili_adsoyad'],
        yetkiliIlgiliBirim: datarow['yetkili_ilgilibirim'] ?? '');
  }
}

class ProjeDDModel {
  String projeId;
  String projeAd;
  String projeFirmaId;
  ProjeDDModel(
      {required this.projeId,
      required this.projeAd,
      required this.projeFirmaId});
  factory ProjeDDModel.fromJSON(Map<String, dynamic> datarow) {
    return ProjeDDModel(
        projeId: datarow['proje_id'],
        projeAd: datarow['proje_ad'],
        projeFirmaId: datarow['proje_firma_id']);
  }
}

class FirmaDDModel {
  String firmaId;
  String firmaIsim;
  FirmaDDModel({required this.firmaId, required this.firmaIsim});
  factory FirmaDDModel.fromJSON(Map<String, dynamic> datarow) {
    return FirmaDDModel(
        firmaId: datarow['firma_id'], firmaIsim: datarow['firma_isim']);
  }
}

class CalisanDDModel {
  String id;
  String firstName;
  String lastName;
  String userfirmAd;
  CalisanDDModel(
      {required this.id,
      required this.firstName,
      required this.lastName,
      required this.userfirmAd});
  factory CalisanDDModel.fromJSON(Map<String, dynamic> json) {
    return CalisanDDModel(
        id: json['id'],
        firstName: json['first_name'],
        lastName: json['last_name'],
        userfirmAd: json['userfirm_ad']);
  }
}

class PersonelDDModel {
  String id;
  String firstName;
  String lastName;

  PersonelDDModel({
    required this.id,
    required this.firstName,
    required this.lastName,
  });
  factory PersonelDDModel.fromJSON(Map<String, dynamic> json) {
    return PersonelDDModel(
      id: json['id'],
      firstName: json['first_name'],
      lastName: json['last_name'],
    );
  }
}

class CalisanYetkiliDDModel {
  String id;
  String firstName;
  String lastName;
  String? image;
  CalisanYetkiliDDModel(
      {required this.id,
      required this.firstName,
      required this.lastName,
      this.image});
  factory CalisanYetkiliDDModel.fromJSON(Map<String, dynamic> datarow) {
    return CalisanYetkiliDDModel(
        id: datarow['id'],
        firstName: datarow['first_name'],
        lastName: datarow['last_name'],
        image: datarow['image'] ?? 'bos');
  }
}

class UnvanDDModel {
  String? unvanId;
  String? unvanAd;
  UnvanDDModel({required this.unvanId, required this.unvanAd});
  factory UnvanDDModel.fromJSON(Map<String, dynamic> datarow) {
    return UnvanDDModel(
        unvanId: datarow['unvan_id'], unvanAd: datarow['unvan_ad']);
  }
}
