import 'package:flutter/material.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../constants/color_constants.dart';

class UserTypeChip extends StatelessWidget {
  final bool isAdmin;

  const UserTypeChip({super.key, required this.isAdmin});

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(top: 15),
      height: context.dynamicHeight(0.05),
      width: context.dynamicWidth(0.4),
      alignment: Alignment.center,
      decoration: BoxDecoration(
        color: isAdmin
            ? ColorsConstants.instance.appGreen
            : ColorsConstants.instance.appBlue,
        borderRadius: BorderRadius.circular(15),
        border: Border.all(
            color: isAdmin
                ? ColorsConstants.instance.navigationMeetButtonGreyColor
                : ColorsConstants.instance.navigationMeetButtonGreyColor,
            width: 1.5),
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          Icon(
            isAdmin
                ? Icons.admin_panel_settings_outlined
                : Icons.account_circle_sharp,
            color: Colors.white,
          ),
          Text(
            isAdmin ? "Yetkili" : "Standart",
            style: Theme.of(context)
                .textTheme
                .bodyLarge
                ?.copyWith(color: Colors.white),
          ),
        ],
      ),
    );
  }
}
