import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../features/customers/cubit/activity_cubit.dart';
import '../../features/customers/cubit/customers_cubit.dart';
import '../constants/color_constants.dart';

class SearchWidget extends StatelessWidget {
  final bool isCustomersPage;
  final TextEditingController tfCustomers;
  final TextEditingController tfActivity;
  final TabController tabController;

  const SearchWidget(
      {super.key,
      required this.isCustomersPage,
      required this.tfCustomers,
      required this.tfActivity,
      required this.tabController});

  @override
  Widget build(BuildContext context) {
    return Container(
      height: context.dynamicHeight(0.0564),
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(8),
          color: ColorsConstants.instance.backgroundColor,
          border: Border.all(color: Colors.grey.withOpacity(0.3))),
      child: Row(
        children: [
          Flexible(
            flex: 2,
            child: TextFormField(
              magnifierConfiguration: TextMagnifierConfiguration.disabled,
              controller: isCustomersPage ? tfCustomers : tfActivity,
              textInputAction: TextInputAction.search,
              onChanged: tabController.index == 0
                  ? (aramasonucu) {
                      context.read<CustomersCubit>().ara(
                            aramasonucu,
                          );
                    }
                  : (aramasonucu) {
                      context
                          .read<ActivityCubit>()
                          .tumAktiviteleriAra(aramasonucu);
                    },
              style: const TextStyle(color: Colors.grey, fontSize: 16.0),
              decoration: const InputDecoration(
                  border: OutlineInputBorder(borderSide: BorderSide.none),
                  prefixIcon: Icon(
                    Icons.search,
                    color: Colors.grey,
                  ),
                  hintText: 'Arama',
                  hintStyle: TextStyle(fontSize: 15.0, color: Colors.grey)),
            ),
          ),
        ],
      ),
    );
  }
}
