import 'package:flutter/material.dart';

import '../../features/auth/login/view/login_view.dart';
import '../cubits/error_handling_bloc.dart';

class ErrorHandlingWidget extends StatelessWidget {
  final Widget child;
  final errorHandlingBloc = ErrorHandlingBloc();

  ErrorHandlingWidget({
    Key? key,
    required this.child,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return StreamBuilder<String>(
      stream: errorHandlingBloc.errorStream,
      builder: (context, snapshot) {
        if (snapshot.hasData && snapshot.data == "tokengecerlidegil") {
          WidgetsBinding.instance.addPostFrameCallback((_) {
            Navigator.pushReplacement(context,
                MaterialPageRoute(builder: (context) => const LoginView()));
          });
        }
        return child;
      },
    );
  }
}
