import 'package:flutter/material.dart';

class CustomPageRoute extends PageRouteBuilder {
  final Widget child;
  final AxisDirection direction;

  CustomPageRoute({
    required this.child,
    this.direction = AxisDirection.left,
    RouteSettings? settings,
  }) : super(
          transitionDuration: const Duration(milliseconds: 500),
          reverseTransitionDuration: const Duration(milliseconds: 500),
          pageBuilder: (context, animation, secondaryAnimation) => child,
          settings: settings,
        );

  @override
  Widget buildTransitions(BuildContext context, Animation<double> animation,
      Animation<double> secondaryAnimation, Widget child) {
    final Offset cBegin = getBeginOffset();
    const Offset cEnd = Offset.zero;
    const Cubic cCurve = Curves.ease;

    final Animatable<Offset> cTween =
        Tween(begin: cBegin, end: cEnd).chain(CurveTween(curve: cCurve));

    return SlideTransition(position: animation.drive(cTween), child: child);
  }

  Offset getBeginOffset() {
    switch (direction) {
      case AxisDirection.up:
        return const Offset(0.0, 1.0);
      case AxisDirection.down:
        return const Offset(0.0, -1.0);
      case AxisDirection.right:
        return const Offset(-1.0, 0.0);
      case AxisDirection.left:
        return const Offset(1.0, 0.0);
    }
  }
}
