import 'package:flutter/material.dart';
import 'package:lottie/lottie.dart';
import 'package:hamlemuhcrm/core/extensions/responsive_extension.dart';

import '../../constants/color_constants.dart';

class InternetUnConnectedWidget extends StatelessWidget {
  const InternetUnConnectedWidget({super.key});
  final String _path = "assets/lottie/unconnected_animation.json";

  @override
  Widget build(BuildContext context) {
    final theme = Theme.of(context);
    return Scaffold(
      backgroundColor: ColorsConstants.instance.backgroundColor,
      body: Center(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            unConnectedAnimation(context, _path),
            Text(
              "İnternet Bağlantınızı \nKontrol Edin !",
              style: theme.textTheme.titleLarge?.copyWith(
                  color: ColorsConstants.instance.baseTheme,
                  fontWeight: FontWeight.bold),
              textAlign: TextAlign.center,
            ),
          ],
        ),
      ),
    );
  }
}

Widget unConnectedAnimation(BuildContext context, String path) {
  return SizedBox(
      height: context.dynamicHeight(0.3), child: Lottie.asset(path));
}
